package org.lightdi.container.meta;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

import org.lightdi.container.config.ComponentConfig.InitMethod;

public class MetaComponent
{
	public class InstanceType
	{
		public static final String SINGLETON = "singleton";
		public static final String PROTOTYPE = "prototype";
	}

	private String name;
	private String className;
	private Object value;
	private String instanceType;

	private Constructor<?> constructor;
	private List<Class<?>> constructorArgTypes = new ArrayList<Class<?>>();
	private List<Object> constructorArgValues = new ArrayList<Object>();

	private List<String> setterNames = new ArrayList<String>();
	private List<Class<?>> setterArgTypes = new ArrayList<Class<?>>();
	private List<Object> setterArgValues = new ArrayList<Object>();

	private List<InitMethod> initMethods = new ArrayList<InitMethod>();

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getClassName()
	{
		return className;
	}

	public void setClassName(String className)
	{
		this.className = className;
	}

	public Constructor<?> getConstructor()
	{
		return constructor;
	}

	public void setConstructor(Constructor<?> constructor)
	{
		this.constructor = constructor;
	}

	public List<Class<?>> getConstructorArgTypes()
	{
		return constructorArgTypes;
	}

	public void setConstructorArgTypes(List<Class<?>> constructorArgTypes)
	{
		this.constructorArgTypes = constructorArgTypes;
	}

	public List<Object> getConstructorArgValues()
	{
		return constructorArgValues;
	}

	public void setConstructorArgValues(List<Object> constructorArgValues)
	{
		this.constructorArgValues = constructorArgValues;
	}

	public List<Class<?>> getSetterArgTypes()
	{
		return setterArgTypes;
	}

	public void setSetterArgTypes(List<Class<?>> setterArgTypes)
	{
		this.setterArgTypes = setterArgTypes;
	}

	public List<Object> getSetterArgValues()
	{
		return setterArgValues;
	}

	public void setSetterArgValues(List<Object> setterArgValues)
	{
		this.setterArgValues = setterArgValues;
	}

	public String getInstanceType()
	{
		return instanceType;
	}

	public void setInstanceType(String instanceType)
	{
		this.instanceType = instanceType;
	}

	public List<String> getSetterNames()
	{
		return setterNames;
	}

	public void setSetterNames(List<String> setterNames)
	{
		this.setterNames = setterNames;
	}

	public Object getValue()
	{
		return value;
	}

	public void setValue(Object value)
	{
		this.value = value;
	}

	public List<InitMethod> getInitMethods()
	{
		return initMethods;
	}

	public void setInitMethods(List<InitMethod> initMethods)
	{
		this.initMethods = initMethods;
	}

}
