/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package org.lightdi.util;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

/**
 * ArrayUtilTest<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class ArrayUtilTest extends TestCase
{

	public void test_toArray_typeParamIsObject() throws Exception
	{
		Object[] expected = new Object[2];
		expected[0] = new Object();
		expected[1] = new String("hoge");

		List<Object> arg = new ArrayList<Object>();
		arg.add(expected[0]);
		arg.add(expected[1]);
		Object[] actual = ArrayUtil.toArray(arg);

		assertEquals(expected[0], actual[0]);
		assertEquals(expected[1], actual[1]);
	}

	public void test_toArray_typeParamIsClass() throws Exception
	{
		Class<?>[] expected = new Class<?>[2];
		expected[0] = Integer.class;
		expected[1] = String.class;

		List<Class<?>> arg = new ArrayList<Class<?>>();
		arg.add(Integer.class);
		arg.add(String.class);
		Object[] actual = ArrayUtil.toArray(arg);

		assertEquals(expected[0], actual[0]);
		assertEquals(expected[1], actual[1]);
	}

	public void test_toArray_paramNull() throws Exception
	{
		Class<?>[] expected = null;
		List<Object> arg = null;
		Object[] actual = ArrayUtil.toArray(arg);
		assertEquals(expected, actual);
	}

	public void test_toArray_paramEmptyList() throws Exception
	{
		Class<?>[] expected = null;
		List<Object> arg = new ArrayList<Object>();
		Object[] actual = ArrayUtil.toArray(arg);
		assertEquals(expected, actual);
	}

	public void test_toArrayList_typeParamIsObject() throws Exception
	{
		Object[] arg = new Object[2];
		arg[0] = new Object();
		arg[1] = new String("hoge");

		List<Object> expected = new ArrayList<Object>();
		expected.add(arg[0]);
		expected.add(arg[1]);
		List<Object> actual = ArrayUtil.toArrayList(arg);

		assertEquals(expected.get(0), actual.get(0));
		assertEquals(expected.get(1), actual.get(1));
	}

	public void test_toArrayList_typeParamIsClass() throws Exception
	{
		Class<?>[] arg = new Class<?>[2];
		arg[0] = Integer.class;
		arg[1] = String.class;

		List<Class<?>> expected = new ArrayList<Class<?>>();
		expected.add(arg[0]);
		expected.add(arg[1]);
		List<Class<?>> actual = ArrayUtil.toArrayList(arg);

		assertEquals(expected.get(0), actual.get(0));
		assertEquals(expected.get(1), actual.get(1));
	}

	public void test_toArrayList_paramNull() throws Exception
	{
		List<Object> expected = null;
		Object[] arg = null;
		List<Object> actual = ArrayUtil.toArrayList(arg);
		assertEquals(expected, actual);
	}

	public void test_toArrayList_paramEmptyList() throws Exception
	{
		List<Object> expected = null;
		Object[] arg = null;
		List<Object> actual = ArrayUtil.toArrayList(arg);
		assertEquals(expected, actual);
	}

	public void test_deepCopy_array() throws Exception
	{
		Object[] arg = new Object[2];
		arg[0] = new Object();
		arg[1] = new Object();
		Object[] result = ArrayUtil.deepCopy(arg);
		assertNotSame(result, arg);
		assertNotSame(result[0], arg[0]);
		assertNotSame(result[1], arg[1]);
	}

	public void test_deepCopy_empty() throws Exception
	{
		Object[] arg = new Object[0];
		try
		{
			ArrayUtil.deepCopy(arg);
			fail("expected exception did not occurred");
		} catch (ArrayIndexOutOfBoundsException e)
		{

		} catch (Exception e)
		{
			fail("expected exception did not occurred");
		}
	}

	public void test_deepCopy_null() throws Exception
	{
		Object[] arg = null;
		Object[] result = ArrayUtil.deepCopy(arg);
		assertSame(result, arg);
	}

}
