package org.lightdi.util;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

public class ObjectUtilTest extends TestCase
{

	public void test_deepCopy_paramNull() throws Exception
	{
		Object arg = null;
		Object res = ObjectUtil.deepCopy(arg);
		assertNull(res);
		assertNull(arg);
	}

	public void test_deepCopy_paramObject() throws Exception
	{
		Object arg = new Object();
		Object res = ObjectUtil.deepCopy(arg);
		assertNotSame(res, arg);
	}

	public void test_deepCopy_paramClass() throws Exception
	{
		Object arg = new Object();
		Object res = ObjectUtil.deepCopy(arg);
		assertNotSame(res, arg);
	}

	public void test_deepCopyList_List() throws Exception
	{
		List<Object> arg = new ArrayList<Object>();
		arg.add(new Object());
		arg.add(new Object());
		List<Object> result = ObjectUtil.deepCopyList(arg);
		assertNotSame(result, arg);
		assertNotSame(result.get(0), arg.get(0));
		assertNotSame(result.get(0), arg.get(0));
	}

	public void test_deepCopyList_empty() throws Exception
	{
		List<Object> arg = new ArrayList<Object>();
		List<Object> result = ObjectUtil.deepCopyList(arg);
		assertNotSame(result, arg);
	}

	public void test_deepCopyList_null() throws Exception
	{
		List<Object> arg = null;
		List<Object> result = ObjectUtil.deepCopyList(arg);
		assertSame(result, arg);
	}

	public void test_deepCopyArray_array() throws Exception
	{
		Object[] arg = new Object[2];
		arg[0] = new Object();
		arg[1] = new Object();
		Object[] result = ObjectUtil.deepCopyArray(arg);
		assertNotSame(result, arg);
		assertNotSame(result[0], arg[0]);
		assertNotSame(result[1], arg[1]);
	}

	public void test_deepCopyArray_empty() throws Exception
	{
		Object[] arg = new Object[0];
		try
		{
			ObjectUtil.deepCopyArray(arg);
			fail("expected exception did not occurred");
		} catch (ArrayIndexOutOfBoundsException e)
		{

		} catch (Exception e)
		{
			fail("expected exception did not occurred");
		}
	}

	public void test_deepCopyArray_null() throws Exception
	{
		Object[] arg = null;
		Object[] result = ObjectUtil.deepCopyArray(arg);
		assertSame(result, arg);
	}

}
