/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.simplefh.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.simplefh.ClassPathResource;
import jp.sourceforge.simplefh.SimpleFileReader;
import jp.sourceforge.simplefh.util.FileResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileReaderImpl
implements SimpleFileReader {
    private String encodingToRead = null;
    private Integer defaultArrayLength = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] read2CharArray(String path) throws IOException {
        char[] cArray;
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            is = FileResourceUtil.getInputStreamFromResourceOrFileSystem(path);
            if (this.encodingToRead == null) {
                String detectedEncoding;
                InputStream isTmp = this.getClass().getClassLoader().getResourceAsStream(path);
                if (isTmp == null) {
                    isTmp = new FileInputStream(path);
                }
                this.encodingToRead = (detectedEncoding = FileResourceUtil.getDetectedEncoding(isTmp)) == null ? "MS932" : detectedEncoding;
                FileResourceUtil.close(isTmp);
            }
            isr = new InputStreamReader(is, this.encodingToRead);
            cArray = this._getFileContentInCharArray(isr, null, this.defaultArrayLength);
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(is);
            FileResourceUtil.close(isr);
            throw throwable;
        }
        FileResourceUtil.close(is);
        FileResourceUtil.close(isr);
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] read2CharArray(File file) throws IOException {
        char[] cArray;
        FileInputStream is = null;
        InputStreamReader isr = null;
        try {
            if (this.encodingToRead == null) {
                FileInputStream isTmp = new FileInputStream(file);
                String detectedEncoding = FileResourceUtil.getDetectedEncoding(isTmp);
                this.encodingToRead = detectedEncoding == null ? "MS932" : detectedEncoding;
                FileResourceUtil.close(isTmp);
            }
            is = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)is, this.encodingToRead);
            cArray = this._getFileContentInCharArray(isr, null, this.defaultArrayLength);
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(isr);
            throw throwable;
        }
        FileResourceUtil.close(isr);
        return cArray;
    }

    @Override
    public char[] read2CharArray(ClassPathResource resourcePath) throws IOException {
        String path = resourcePath.getResourcePath();
        return this.read2CharArray(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read2ByteArray(String path) throws IOException {
        InputStream is = null;
        try {
            is = FileResourceUtil.getInputStreamFromResourceOrFileSystem(path);
            if (this.encodingToRead == null) {
                String detectedEncoding;
                InputStream isTmp = this.getClass().getClassLoader().getResourceAsStream(path);
                if (isTmp == null) {
                    isTmp = new FileInputStream(path);
                }
                this.encodingToRead = (detectedEncoding = FileResourceUtil.getDetectedEncoding(isTmp)) == null ? "MS932" : detectedEncoding;
                FileResourceUtil.close(isTmp);
            }
            byte[] retArr = this._getFileContentInByteArray(is, null, this.defaultArrayLength);
            byte[] byArray = new String(retArr, this.encodingToRead).getBytes("MS932");
            return byArray;
        }
        finally {
            FileResourceUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read2ByteArray(File file) throws IOException {
        BufferedInputStream bis = null;
        byte[] retByteArr = null;
        try {
            if (this.encodingToRead == null) {
                FileInputStream isTmp = new FileInputStream(file);
                String detectedEncoding = FileResourceUtil.getDetectedEncoding(isTmp);
                this.encodingToRead = detectedEncoding == null ? "MS932" : detectedEncoding;
                FileResourceUtil.close(isTmp);
            }
            bis = new BufferedInputStream(new FileInputStream(file));
            retByteArr = new byte[(int)file.length()];
            bis.read(retByteArr);
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(bis);
            throw throwable;
        }
        FileResourceUtil.close(bis);
        return new String(retByteArr, this.encodingToRead).getBytes("MS932");
    }

    @Override
    public byte[] read2ByteArray(ClassPathResource resourcePath) throws IOException {
        String path = resourcePath.getResourcePath();
        return this.read2ByteArray(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> read2StringLineList(String path) throws IOException {
        ArrayList<String> retList = new ArrayList<String>();
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            is = FileResourceUtil.getInputStreamFromResourceOrFileSystem(path);
            if (this.encodingToRead == null) {
                String detectedEncoding;
                InputStream isTmp = this.getClass().getClassLoader().getResourceAsStream(path);
                if (isTmp == null) {
                    isTmp = new FileInputStream(path);
                }
                this.encodingToRead = (detectedEncoding = FileResourceUtil.getDetectedEncoding(isTmp)) == null ? "MS932" : detectedEncoding;
                FileResourceUtil.close(isTmp);
            }
            isr = new InputStreamReader(is, this.encodingToRead);
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                retList.add(line);
            }
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(is);
            FileResourceUtil.close(isr);
            FileResourceUtil.close(br);
            throw throwable;
        }
        FileResourceUtil.close(is);
        FileResourceUtil.close(isr);
        FileResourceUtil.close(br);
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> read2StringLineList(File file) throws IOException {
        ArrayList<String> retList = new ArrayList<String>();
        FileInputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            if (this.encodingToRead == null) {
                FileInputStream isTmp = new FileInputStream(file);
                String detectedEncoding = FileResourceUtil.getDetectedEncoding(isTmp);
                this.encodingToRead = detectedEncoding == null ? "MS932" : detectedEncoding;
                FileResourceUtil.close(isTmp);
            }
            is = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)is, this.encodingToRead);
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                retList.add(line);
            }
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(is);
            FileResourceUtil.close(isr);
            FileResourceUtil.close(br);
            throw throwable;
        }
        FileResourceUtil.close(is);
        FileResourceUtil.close(isr);
        FileResourceUtil.close(br);
        return retList;
    }

    @Override
    public List<String> read2StringLineList(ClassPathResource resourcePath) throws IOException {
        String path = resourcePath.getResourcePath();
        return this.read2StringLineList(path);
    }

    @Override
    public String[] read2StringLineArray(String path) throws IOException {
        List<String> strList = this.read2StringLineList(path);
        String[] retArr = new String[strList.size()];
        int retArrLen = retArr.length;
        for (int i = 0; i < retArrLen; ++i) {
            retArr[i] = strList.get(i);
        }
        return retArr;
    }

    @Override
    public String[] read2StringLineArray(File file) throws IOException {
        List<String> strList = this.read2StringLineList(file);
        String[] retArr = new String[strList.size()];
        int retArrLen = retArr.length;
        for (int i = 0; i < retArrLen; ++i) {
            retArr[i] = strList.get(i);
        }
        return retArr;
    }

    @Override
    public String[] read2StringLineArray(ClassPathResource resourcePath) throws IOException {
        String path = resourcePath.getResourcePath();
        return this.read2StringLineArray(path);
    }

    private byte[] _getFileContentInByteArray(InputStream is, byte[] registeredArr, int bufArrLen) throws IOException {
        int registeredArrLen = registeredArr == null ? 0 : registeredArr.length;
        byte[] bufArr = new byte[bufArrLen];
        is.read(bufArr);
        Integer endIdxOfArr = null;
        for (int i = 0; i < bufArrLen; ++i) {
            if (bufArr[i] != 0) continue;
            endIdxOfArr = i;
            break;
        }
        byte[] resultArr = null;
        if (endIdxOfArr == null) {
            if (registeredArrLen == 0) {
                resultArr = new byte[bufArrLen];
                for (int i = 0; i < bufArrLen; ++i) {
                    resultArr[i] = bufArr[i];
                }
            } else {
                resultArr = new byte[registeredArrLen + bufArrLen];
                System.arraycopy(registeredArr, 0, resultArr, 0, registeredArrLen);
                System.arraycopy(bufArr, 0, resultArr, registeredArrLen, bufArrLen);
            }
            return this._getFileContentInByteArray(is, bufArr, bufArrLen);
        }
        if (registeredArrLen == 0) {
            resultArr = new byte[endIdxOfArr.intValue()];
            for (int i = 0; i < endIdxOfArr; ++i) {
                resultArr[i] = bufArr[i];
            }
        } else {
            resultArr = new byte[registeredArrLen + endIdxOfArr];
            System.arraycopy(registeredArr, 0, resultArr, 0, registeredArrLen);
            System.arraycopy(bufArr, 0, resultArr, registeredArrLen, endIdxOfArr);
        }
        return resultArr;
    }

    private char[] _getFileContentInCharArray(InputStreamReader isr, char[] registeredArr, int bufArrLen) throws IOException {
        int registeredArrLen = registeredArr == null ? 0 : registeredArr.length;
        char[] bufArr = new char[bufArrLen];
        isr.read(bufArr);
        Integer endIdxOfArr = null;
        for (int i = 0; i < bufArrLen; ++i) {
            if (bufArr[i] != '\u0000') continue;
            endIdxOfArr = i;
            break;
        }
        char[] resultArr = null;
        if (endIdxOfArr == null) {
            if (registeredArrLen == 0) {
                resultArr = new char[bufArrLen];
                for (int i = 0; i < bufArrLen; ++i) {
                    resultArr[i] = bufArr[i];
                }
            } else {
                resultArr = new char[registeredArrLen + bufArrLen];
                System.arraycopy(registeredArr, 0, resultArr, 0, registeredArrLen);
                System.arraycopy(bufArr, 0, resultArr, registeredArrLen, bufArrLen);
            }
            return this._getFileContentInCharArray(isr, bufArr, bufArrLen);
        }
        if (registeredArrLen == 0) {
            resultArr = new char[endIdxOfArr.intValue()];
            for (int i = 0; i < endIdxOfArr; ++i) {
                resultArr[i] = bufArr[i];
            }
        } else {
            resultArr = new char[registeredArrLen + endIdxOfArr];
            System.arraycopy(registeredArr, 0, resultArr, 0, registeredArrLen);
            System.arraycopy(bufArr, 0, resultArr, registeredArrLen, endIdxOfArr);
        }
        return resultArr;
    }

    @Override
    public String getEncodingToRead() {
        return this.encodingToRead;
    }

    @Override
    public SimpleFileReader setEncodingToRead(String encodingToRead) {
        this.encodingToRead = encodingToRead;
        return this;
    }

    @Override
    public Integer getDefaultArrayLength() {
        return this.defaultArrayLength;
    }

    @Override
    public SimpleFileReader setDefaultArrayLength(Integer defaultArrayLength) {
        this.defaultArrayLength = defaultArrayLength;
        return this;
    }
}

