/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package jp.sourceforge.simplefh;

/**
 * Class path resource<br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class ClassPathResource
{
	/**
	 * Constructor
	 * 
	 * @param resourcePath
	 *            resource path value
	 */
	public ClassPathResource(String resourcePath)
	{
		this.setResourcePath(resourcePath);
	}

	private String resourcePath;

	/**
	 * Get resource path.
	 * 
	 * @return resource path
	 */
	public String getResourcePath()
	{
		return resourcePath;
	}

	/**
	 * Set resource path.
	 * 
	 * @param resourcePath
	 *            resource path
	 * @throws IllegalArgumentException
	 *             invalid resource path value
	 */
	public void setResourcePath(String resourcePath) throws IllegalArgumentException
	{
		if (resourcePath.matches("^/"))
			throw new IllegalArgumentException("Invalid resource path value : "
			        + resourcePath);
		this.resourcePath = resourcePath;
	}

}
