/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.sunfish.javapp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class JavapExecute {
    private String commandPath;

    public JavapExecute(String path) {
        this.commandPath = path == null || "".equals(path) ? "javap" : path;
    }

    public String exec(String classPath, String className, boolean isBackward, boolean isCode, boolean isLine, boolean isPublic, boolean isProtected, boolean isPackage, boolean isPrivate, boolean isSignature, boolean isVerbose) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.commandPath);
        list.add("-classpath");
        list.add(classPath);
        if (isBackward) {
            list.add("-b");
        }
        if (isCode) {
            list.add("-c");
        }
        if (isLine) {
            list.add("-l");
        }
        if (isPublic) {
            list.add("-public");
        }
        if (isProtected) {
            list.add("-protected");
        }
        if (isPackage) {
            list.add("-package");
        }
        if (isPrivate) {
            list.add("-private");
        }
        if (isSignature) {
            list.add("-s");
        }
        if (isVerbose) {
            list.add("-verbose");
        }
        list.add(className);
        String[] command = list.toArray(new String[list.size()]);
        StringBuffer buf = new StringBuffer();
        buf.append('>');
        int i = 0;
        while (i < command.length) {
            buf.append(command[i]).append(' ');
            ++i;
        }
        buf.append('\n');
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = in.readLine()) != null) {
                buf.append(line).append('\n');
            }
            while ((line = err.readLine()) != null) {
                buf.append(line).append('\n');
            }
        }
        catch (IOException ex) {
            buf.append(ex.getMessage());
        }
        return buf.toString();
    }
}

