/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ModifyLayerOutPointOperation
extends ProjectOperation {
    private final String _compId;
    private volatile List<Entry> _entries = Util.newList();

    public ModifyLayerOutPointOperation(ProjectManager projectManager, LayerComposition comp, Object[][] layersAndOutPoints, Time deltaTime, String relation) {
        super(projectManager, "\u30a2\u30a6\u30c8\u30dd\u30a4\u30f3\u30c8\u306e\u5909\u66f4", relation);
        this._noEffect = true;
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        Time oneFrame = Time.fromFrameNumber((long)1L, (Time)comp.getFrameDuration());
        Object[][] objectArray = layersAndOutPoints;
        int n = layersAndOutPoints.length;
        int n2 = 0;
        while (n2 < n) {
            Time startTime;
            Time endTime;
            Time duration;
            MediaInput input;
            Time inPoint;
            Object[] o = objectArray[n2];
            Layer layer = (Layer)o[0];
            Time newOutPoint = ((Time)o[1]).add(deltaTime);
            if (!newOutPoint.after(inPoint = layer.getInPoint())) {
                newOutPoint = inPoint.add(oneFrame);
            }
            if (layer instanceof MediaItemLayer && !LayerNature.isTimeRemapEnabled((Layer)layer) && (input = ((MediaItemLayer)layer).getMediaInput()) != null && (duration = input.getDuration()) != null && newOutPoint.after(endTime = (startTime = layer.getStartTime()).add(new Time((long)((double)duration.timeValue / Math.abs(layer.getRate())), duration.timeScale)))) {
                newOutPoint = endTime;
            }
            Time oldOutPoint = layer.getOutPoint();
            this._entries.add(new Entry(layer.getId(), oldOutPoint, newOutPoint));
            if (!newOutPoint.equals((Object)oldOutPoint)) {
                this._noEffect = false;
            }
            ++n2;
        }
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyOutPoint(false, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyOutPoint(true, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyOutPoint(boolean undo, Project project, ProjectManager pm) {
        List layers = null;
        if (pm != null) {
            layers = Util.newList();
        }
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        for (Entry e : this._entries) {
            Layer layer = comp.getLayer(e.layerId);
            layer.setOutPoint(undo ? e.oldOutPoint : e.newOutPoint);
            if (pm == null) continue;
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
    }

    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            this.modifyOutPoint(false, project, null);
            return true;
        }
        if (!(operation instanceof ModifyLayerOutPointOperation)) {
            return false;
        }
        ModifyLayerOutPointOperation newOp = (ModifyLayerOutPointOperation)operation;
        if (!newOp._compId.equals(this._compId) || newOp._entries.size() != this._entries.size()) {
            return false;
        }
        List mergedEntries = Util.newList();
        boolean noEffect = true;
        int i = 0;
        int n = this._entries.size();
        while (i < n) {
            Entry oldEntry = this._entries.get(i);
            Entry newEntry = newOp._entries.get(i);
            if (!newEntry.layerId.equals(oldEntry.layerId)) {
                return false;
            }
            mergedEntries.add(new Entry(oldEntry.layerId, oldEntry.oldOutPoint, newEntry.newOutPoint));
            if (!newEntry.newOutPoint.equals((Object)oldEntry.oldOutPoint)) {
                noEffect = false;
            }
            ++i;
        }
        this._entries = mergedEntries;
        this.modifyOutPoint(false, project, pm);
        this._noEffect = noEffect;
        return true;
    }

    private class Entry {
        final String layerId;
        final Time oldOutPoint;
        final Time newOutPoint;

        public Entry(String layerId, Time oldOutPoint, Time newOutPoint) {
            this.layerId = layerId;
            this.oldOutPoint = oldOutPoint;
            this.newOutPoint = newOutPoint;
        }
    }
}

