/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.app.project.AbstractNewLayerOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.services.ProjectElementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCameraLayerOperation
extends AbstractNewLayerOperation<CameraLayer> {
    public NewCameraLayerOperation(ProjectManager projectManager, LayerComposition comp) {
        super(projectManager, comp, "\u65b0\u898f\u30ab\u30e1\u30e9");
    }

    @Override
    protected CameraLayer createNewLayer(ProjectManager projectManager, LayerComposition comp, ProjectElementFactory factory) {
        CameraLayer cameraLayer = factory.newCameraLayer();
        cameraLayer.setName(projectManager.getUnusedLayerName(comp, "\u30ab\u30e1\u30e9"));
        double w = comp.getSize().width;
        double h = comp.getSize().height;
        double fovx = 39.6;
        double zoom = w / (2.0 * Math.tan(Math.toRadians(fovx / 2.0)));
        cameraLayer.getZoom().clearKeyframes((Object)zoom);
        cameraLayer.getNear().clearKeyframes((Object)(zoom / 2.0));
        cameraLayer.getFar().clearKeyframes((Object)(zoom * 10.0));
        cameraLayer.getPosition().clearKeyframes((Object)new Vec3d(w / 2.0, h / 2.0, -zoom));
        cameraLayer.getPointOfInterest().clearKeyframes((Object)new Vec3d(w / 2.0, h / 2.0));
        return cameraLayer;
    }
}

