/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views;

import ch.kuramo.javie.app.player.MediaPlayer;
import ch.kuramo.javie.app.player.PlayerInfoAction;
import ch.kuramo.javie.app.player.PlayerMuteAction;
import ch.kuramo.javie.app.player.PlayerPinAction;
import ch.kuramo.javie.app.player.PlayerResolutionAction;
import ch.kuramo.javie.app.player.PlayerZoomAction;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.MediaItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class MediaPlayerView
extends ViewPart
implements IPartListener {
    public static final String ID = "ch.kuramo.javie.app.views.mediaPlayerView";
    private MediaItem _mediaItem;
    private MediaPlayer _mediaPlayer;
    private PlayerZoomAction _zoomAction;
    private PlayerResolutionAction _resolutionAction;
    private PlayerMuteAction _muteAction;
    private PlayerInfoAction _infoAction;
    private PlayerPinAction _pinAction;

    public void createPartControl(Composite parent) {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getSite().getWorkbenchWindow());
        if (pm == null) {
            throw new IllegalStateException("No ProjectManager exists for this window.");
        }
        this._mediaItem = (MediaItem)pm.getShadow().getItem(this.getItemId());
        if (this._mediaItem == null) {
            throw new IllegalStateException("no such MediaItem found: " + this.getItemId());
        }
        this.setPartName(this._mediaItem.getName());
        this._mediaPlayer = new MediaPlayer(parent, 0);
        this._mediaPlayer.setMediaItem(this._mediaItem);
        this.configureActionBars();
        if (this._mediaItem instanceof CompositionItem) {
            LayerCompositionView.connectToPlayer(this);
        }
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    private void configureActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        this._zoomAction = new PlayerZoomAction(this._mediaPlayer);
        tbm.add((IAction)this._zoomAction);
        this._resolutionAction = new PlayerResolutionAction(this._mediaPlayer);
        tbm.add((IAction)this._resolutionAction);
        this._muteAction = new PlayerMuteAction(this._mediaPlayer);
        tbm.add((IAction)this._muteAction);
        tbm.add((IContributionItem)new Separator());
        this._infoAction = new PlayerInfoAction(this._mediaPlayer);
        tbm.add((IAction)this._infoAction);
        this._pinAction = new PlayerPinAction();
        tbm.add((IAction)this._pinAction);
        actionBars.updateActionBars();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void setFocus() {
        this._mediaPlayer.setFocus();
    }

    String getItemId() {
        return this.getViewSite().getSecondaryId();
    }

    MediaPlayer getMediaPlayer() {
        return this._mediaPlayer;
    }

    public boolean isPinned() {
        return this._pinAction.isChecked();
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this) {
            this._mediaPlayer.close();
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }
}

