/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.project.ModifyLayerBlendModeOperation;
import ch.kuramo.javie.app.project.ModifyLayerParentOperation;
import ch.kuramo.javie.app.project.ModifyLayerTrackMatteOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.layercomp.AudioElement;
import ch.kuramo.javie.app.views.layercomp.AudioSwitch;
import ch.kuramo.javie.app.views.layercomp.CTCRSwitch;
import ch.kuramo.javie.app.views.layercomp.CameraOptionsElement;
import ch.kuramo.javie.app.views.layercomp.CameraTransformElement;
import ch.kuramo.javie.app.views.layercomp.EffectsElement;
import ch.kuramo.javie.app.views.layercomp.EffectsSwitch;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.ShySwitch;
import ch.kuramo.javie.app.views.layercomp.SwitchGroup;
import ch.kuramo.javie.app.views.layercomp.TextElement;
import ch.kuramo.javie.app.views.layercomp.ThreeDSwitch;
import ch.kuramo.javie.app.views.layercomp.TimeRemapElement;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.app.views.layercomp.TransformElement;
import ch.kuramo.javie.app.views.layercomp.VideoSwitch;
import ch.kuramo.javie.core.BlendMode;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.NullLayer;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.Util;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerElement
extends Element {
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    public final Layer layer;
    private final LayerComposition composition;
    private final List<Element> children = Util.newList();
    private final Map<Class<? extends Element>, Element> childrenMap = Util.newMap();
    private final SwitchGroup showHideColumnSwitches = new SwitchGroup();
    private final SwitchGroup switchesColumnSwitches = new SwitchGroup();
    private ComboBoxViewerCellEditor modeEditor;
    private ComboBoxViewerCellEditor trackMatteEditor;
    private ComboBoxViewerCellEditor parentEditor;
    private static final Object NO_PARENT = new Object();

    public LayerElement(TreeViewer viewer, Layer layer) {
        super(viewer);
        this.layer = layer;
        this.composition = (LayerComposition)viewer.getData("LAYER_COMPOSITION");
        ProjectManager pm = (ProjectManager)viewer.getData("PROJECT_MANAGER");
        if (LayerNature.isVideoNature((Layer)layer)) {
            this.showHideColumnSwitches.add(new VideoSwitch(pm, layer));
        } else {
            this.showHideColumnSwitches.addPlaceholder();
        }
        if (LayerNature.isAudioNature((Layer)layer)) {
            this.showHideColumnSwitches.add(new AudioSwitch(pm, layer));
        } else {
            this.showHideColumnSwitches.addPlaceholder();
        }
        this.switchesColumnSwitches.add(new ShySwitch(pm, layer));
        if (layer instanceof EffectableLayer) {
            this.switchesColumnSwitches.add(new EffectsSwitch(pm, (EffectableLayer)layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
        if (LayerNature.isCTCRNature((Layer)layer)) {
            this.switchesColumnSwitches.add(new CTCRSwitch(pm, layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
        if (layer instanceof TransformableLayer && LayerNature.isThreeDNature((Layer)layer)) {
            this.switchesColumnSwitches.add(new ThreeDSwitch(pm, (TransformableLayer)layer));
        } else {
            this.switchesColumnSwitches.addPlaceholder();
        }
    }

    @Override
    public Image getColumnImage(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.layer instanceof ItemLayer) {
                    return ImageUtil.getItemIcon(((ItemLayer)this.layer).getItem());
                }
                if (this.layer instanceof CameraLayer) {
                    return ImageUtil.getCameraIcon();
                }
                if (this.layer instanceof NullLayer) {
                    return ImageUtil.getNullIcon();
                }
                if (this.layer instanceof TextLayer) {
                    return ImageUtil.getTextIcon();
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
        }
        return null;
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                ItemLayer itemLayer;
                String itemName;
                String name = this.layer.getName();
                if (this.layer instanceof ItemLayer && !name.equals(itemName = (itemLayer = (ItemLayer)this.layer).getItem().getName())) {
                    name = String.format("%s  <%s>", name, itemName);
                }
                return name;
            }
            case 2: {
                return this.layer instanceof MediaLayer ? String.valueOf(COCOA ? "  " : "") + ((MediaLayer)this.layer).getBlendMode().label() : null;
            }
            case 3: {
                if (this.layer instanceof MediaLayer && this.getTrackMatteLayer() != null) {
                    TrackMatte trackMatte = ((MediaLayer)this.layer).getTrackMatte();
                    String label = trackMatte.label();
                    return String.valueOf(COCOA ? "  " : "") + (trackMatte != TrackMatte.NONE ? label : " - ");
                }
                return null;
            }
            case 4: {
                Layer parent = this.layer.getParent();
                return String.valueOf(COCOA ? "  " : "") + (parent != null ? parent.getName() : " - ");
            }
        }
        return null;
    }

    private MediaLayer getTrackMatteLayer() {
        Layer matteLayer;
        List layers;
        int layerIndex;
        if (this.layer instanceof MediaLayer && (layerIndex = (layers = this.composition.getLayers()).indexOf(this.layer)) + 1 < layers.size() && (matteLayer = (Layer)layers.get(layerIndex + 1)) instanceof MediaLayer) {
            return (MediaLayer)matteLayer;
        }
        return null;
    }

    private <E extends Element> E getChildElement(Class<E> clazz) {
        Element element = this.childrenMap.get(clazz);
        if (element == null) {
            try {
                element = (Element)clazz.getConstructor(this.getClass()).newInstance(this);
            }
            catch (Exception e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            this.childrenMap.put(clazz, element);
        }
        return (E)element;
    }

    private void prepareChildren() {
        this.children.clear();
        if (LayerNature.isTimeRemapEnabled((Layer)this.layer)) {
            this.children.add(this.getChildElement(TimeRemapElement.class));
        }
        if (this.layer instanceof TextLayer) {
            this.children.add(this.getChildElement(TextElement.class));
        }
        if (this.layer instanceof EffectableLayer && !((EffectableLayer)this.layer).getEffects().isEmpty()) {
            this.children.add(this.getChildElement(EffectsElement.class));
        }
        if (this.layer instanceof TransformableLayer && LayerNature.isVideoNature((Layer)this.layer)) {
            this.children.add(this.getChildElement(TransformElement.class));
        } else if (this.layer instanceof CameraLayer) {
            this.children.add(this.getChildElement(CameraTransformElement.class));
            this.children.add(this.getChildElement(CameraOptionsElement.class));
        }
        if (this.layer instanceof MediaLayer && LayerNature.isAudioNature((Layer)this.layer)) {
            this.children.add(this.getChildElement(AudioElement.class));
        }
        this.childrenMap.values().retainAll(this.children);
    }

    @Override
    public boolean hasChildren() {
        this.prepareChildren();
        return this.children.size() > 0;
    }

    @Override
    public Element[] getChildren() {
        this.prepareChildren();
        return this.children.toArray(new Element[this.children.size()]);
    }

    @Override
    public void paintColumn(Event event) {
        switch (event.index) {
            case 5: {
                this.showHideColumnSwitches.paint(event);
                break;
            }
            case 1: {
                this.switchesColumnSwitches.paint(event);
                break;
            }
            case 7: {
                TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
                tm.drawLayer(event, this.layer);
                break;
            }
            default: {
                super.paintColumn(event);
            }
        }
    }

    @Override
    public void updateCursor(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 7: {
                TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
                tm.updateCursor(event, this.layer);
                break;
            }
            default: {
                super.updateCursor(event, columnIndex);
            }
        }
    }

    @Override
    public void mouseDown(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 5: {
                this.showHideColumnSwitches.mouseDown(event);
                break;
            }
            case 1: {
                this.switchesColumnSwitches.mouseDown(event);
                break;
            }
            case 3: {
                if (!(this.layer instanceof MediaLayer) || this.getTrackMatteLayer() == null) break;
            }
            case 2: {
                if (!(this.layer instanceof MediaLayer)) break;
            }
            case 4: {
                if (event.button != 1) break;
                this.viewer.editElement((Object)this, columnIndex);
                break;
            }
            case 7: {
                TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
                tm.mouseDown(event, this.layer);
                break;
            }
            default: {
                super.mouseDown(event, columnIndex);
            }
        }
    }

    @Override
    public boolean canEdit(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return this.layer instanceof MediaLayer;
            }
            case 3: {
                return this.layer instanceof MediaLayer && this.getTrackMatteLayer() != null;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                if (this.modeEditor == null) {
                    this.modeEditor = new ComboBoxViewerCellEditor((Composite)this.viewer.getTree(), 8);
                    this.modeEditor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                    this.modeEditor.setLabelProvider((IBaseLabelProvider)new BlendModeLabelProvider());
                    this.modeEditor.setActivationStyle(4);
                    ((Combo)this.modeEditor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            LayerElement.this.setCellEditorValue(2, LayerElement.this.modeEditor.getValue());
                        }
                    });
                }
                this.modeEditor.setInput(BlendMode.values());
                return this.modeEditor;
            }
            case 3: {
                if (this.trackMatteEditor == null) {
                    this.trackMatteEditor = new ComboBoxViewerCellEditor((Composite)this.viewer.getTree(), 8);
                    this.trackMatteEditor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                    this.trackMatteEditor.setLabelProvider((IBaseLabelProvider)new TrackMatteLabelProvider());
                    this.trackMatteEditor.setActivationStyle(4);
                    ((Combo)this.trackMatteEditor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            LayerElement.this.setCellEditorValue(3, LayerElement.this.trackMatteEditor.getValue());
                        }
                    });
                }
                this.trackMatteEditor.setInput(TrackMatte.values());
                return this.trackMatteEditor;
            }
            case 4: {
                if (this.parentEditor == null) {
                    this.parentEditor = new ComboBoxViewerCellEditor((Composite)this.viewer.getTree(), 8);
                    this.parentEditor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                    this.parentEditor.setLabelProvider((IBaseLabelProvider)new ParentLabelProvider());
                    this.parentEditor.setActivationStyle(4);
                    ((Combo)this.parentEditor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            LayerElement.this.setCellEditorValue(4, LayerElement.this.parentEditor.getValue());
                        }
                    });
                }
                this.parentEditor.setInput(this.getLayersForParentEditor());
                return this.parentEditor;
            }
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return ((MediaLayer)this.layer).getBlendMode();
            }
            case 3: {
                return ((MediaLayer)this.layer).getTrackMatte();
            }
            case 4: {
                Layer parent = this.layer.getParent();
                return parent != null ? parent : NO_PARENT;
            }
        }
        return true;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        ProjectManager pm = (ProjectManager)this.viewer.getData("PROJECT_MANAGER");
        switch (columnIndex) {
            case 2: {
                pm.postOperation(new ModifyLayerBlendModeOperation(pm, (MediaLayer)this.layer, (BlendMode)value));
                break;
            }
            case 3: {
                pm.postOperation(new ModifyLayerTrackMatteOperation(pm, (MediaLayer)this.layer, (TrackMatte)value));
                break;
            }
            case 4: {
                pm.postOperation(new ModifyLayerParentOperation(pm, this.layer, value != NO_PARENT ? (Layer)value : null));
            }
        }
    }

    private Object[] getLayersForParentEditor() {
        List layers = Util.newList();
        LayerComposition comp = (LayerComposition)this.viewer.getData("LAYER_COMPOSITION");
        Iterator iterator = comp.getLayers().iterator();
        while (iterator.hasNext()) {
            Layer l;
            Layer tmp = l = (Layer)iterator.next();
            while (tmp != null && tmp != this.layer) {
                tmp = tmp.getParent();
            }
            if (tmp != null) continue;
            layers.add(l);
        }
        layers.add(NO_PARENT);
        Collections.reverse(layers);
        return layers.toArray();
    }

    private static class BlendModeLabelProvider
    extends LabelProvider {
        private BlendModeLabelProvider() {
        }

        public String getText(Object element) {
            return ((BlendMode)element).label();
        }
    }

    private static class ParentLabelProvider
    extends LabelProvider {
        private ParentLabelProvider() {
        }

        public String getText(Object element) {
            return element != NO_PARENT ? ((Layer)element).getName() : "\u306a\u3057";
        }
    }

    private class TrackMatteLabelProvider
    extends LabelProvider {
        private TrackMatteLabelProvider() {
        }

        public String getText(Object element) {
            TrackMatte trackMatte = (TrackMatte)element;
            return trackMatte == TrackMatte.NONE ? trackMatte.label() : String.format("%s - %s", trackMatte.label(), LayerElement.this.getTrackMatteLayer().getName());
        }
    }
}

