/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects;

import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.GLProgram;
import ch.kuramo.javie.api.annotations.GLShader;
import ch.kuramo.javie.api.plugin.PIShaderProgram;
import ch.kuramo.javie.api.plugin.PIShaderRegistry;
import ch.kuramo.javie.api.plugin.PIVideoBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class VideoEffectUtil {
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram
    public static final String[] CONVOLUTION_1D_H = VideoEffectUtil.createConvolution1DSource(true);
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram
    public static final String[] CONVOLUTION_1D_V = VideoEffectUtil.createConvolution1DSource(false);
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram
    public static final String[] CONVOLUTION = new String[]{"uniform sampler2DRect texture;", "uniform int ksize;", "uniform float kernel[49];", "uniform vec2 offset[49];", "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tfor (int i = 0; i < ksize; ++i) {", "\t\tvec4 src = texture2DRect(texture, texCoord + offset[i]);", "\t\tsum += kernel[i] * src;", "\t}", "\tgl_FragColor = sum;", "}"};

    public static void ortho2D(GL gl, GLU glu, int width, int height) {
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0, (double)width, 0.0, (double)height);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    private static final String[] createConvolution1DSource(boolean h) {
        return new String[]{"uniform sampler2DRect texture;", "uniform int radius;", "uniform float kernel[101];", "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tfor (int i = -radius; i <= radius; ++i) {", h ? "\t\tvec4 src = texture2DRect(texture, vec2(texCoord.s+float(i), texCoord.t));" : "\t\tvec4 src = texture2DRect(texture, vec2(texCoord.s, texCoord.t+float(i)));", "\t\tsum += kernel[radius+i] * src;", "\t}", "\tgl_FragColor = sum;", "}"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convolution1D(PIVideoBuffer src, PIVideoBuffer dst, boolean horizontal, int radius, float[] kernel, GL gl, GLU glu, PIShaderRegistry shaders) {
        PIShaderProgram program;
        VideoBounds srcBounds = src.getBounds();
        VideoBounds dstBounds = dst.getBounds();
        float x1 = (float)(dstBounds.x - srcBounds.x);
        float y1 = (float)(dstBounds.y - srcBounds.y);
        float x2 = x1 + (float)dstBounds.width;
        float y2 = y1 + (float)dstBounds.height;
        VideoEffectUtil.ortho2D(gl, glu, dstBounds.width, dstBounds.height);
        gl.glTranslatef(-x1, -y1, 0.0f);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, dst.getTexture(), 0);
        gl.glDrawBuffer(36064);
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, src.getTexture());
        PIShaderProgram pIShaderProgram = program = shaders.getProgram(VideoEffectUtil.class, horizontal ? "CONVOLUTION_1D_H" : "CONVOLUTION_1D_V");
        synchronized (pIShaderProgram) {
            gl.glUseProgram(program.getProgram());
            gl.glUniform1i(program.getUniformLocation("texture"), 0);
            gl.glUniform1i(program.getUniformLocation("radius"), radius);
            gl.glUniform1fv(program.getUniformLocation("kernel[0]"), radius * 2 + 1, kernel, 0);
            gl.glBegin(7);
            gl.glTexCoord2f(x1, y1);
            gl.glVertex2f(x1, y1);
            gl.glTexCoord2f(x2, y1);
            gl.glVertex2f(x2, y1);
            gl.glTexCoord2f(x2, y2);
            gl.glVertex2f(x2, y2);
            gl.glTexCoord2f(x1, y2);
            gl.glVertex2f(x1, y2);
            gl.glEnd();
            gl.glFinish();
            gl.glUseProgram(0);
        }
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, 0);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convolution(PIVideoBuffer src, PIVideoBuffer dst, int ksize, float[] kernel, float[] offset, GL gl, GLU glu, PIShaderRegistry shaders) {
        PIShaderProgram program;
        VideoBounds srcBounds = src.getBounds();
        VideoBounds dstBounds = dst.getBounds();
        float x1 = (float)(dstBounds.x - srcBounds.x);
        float y1 = (float)(dstBounds.y - srcBounds.y);
        float x2 = x1 + (float)dstBounds.width;
        float y2 = y1 + (float)dstBounds.height;
        VideoEffectUtil.ortho2D(gl, glu, dstBounds.width, dstBounds.height);
        gl.glTranslatef(-x1, -y1, 0.0f);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, dst.getTexture(), 0);
        gl.glDrawBuffer(36064);
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, src.getTexture());
        PIShaderProgram pIShaderProgram = program = shaders.getProgram(VideoEffectUtil.class, "CONVOLUTION");
        synchronized (pIShaderProgram) {
            gl.glUseProgram(program.getProgram());
            gl.glUniform1i(program.getUniformLocation("texture"), 0);
            gl.glUniform1i(program.getUniformLocation("ksize"), ksize);
            gl.glUniform1fv(program.getUniformLocation("kernel[0]"), ksize, kernel, 0);
            gl.glUniform2fv(program.getUniformLocation("offset[0]"), ksize * 2, offset, 0);
            gl.glBegin(7);
            gl.glTexCoord2f(x1, y1);
            gl.glVertex2f(x1, y1);
            gl.glTexCoord2f(x2, y1);
            gl.glVertex2f(x2, y1);
            gl.glTexCoord2f(x2, y2);
            gl.glVertex2f(x2, y2);
            gl.glTexCoord2f(x1, y2);
            gl.glVertex2f(x1, y2);
            gl.glEnd();
            gl.glFinish();
            gl.glUseProgram(0);
        }
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, 0);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
    }

    public static VideoBounds expandBounds(VideoBounds bounds, int expand, boolean h, boolean v) {
        int dx = 0;
        int dy = 0;
        int dw = 0;
        int dh = 0;
        if (h) {
            dx = -expand;
            dw = expand * 2;
        }
        if (v) {
            dy = -expand;
            dh = expand * 2;
        }
        return new VideoBounds(bounds.x + (double)dx, bounds.y + (double)dy, bounds.width + dw, bounds.height + dh);
    }

    public static void setNearest(PIVideoBuffer vb, GL gl) {
        gl.glBindTexture(34037, vb.getTexture());
        gl.glTexParameteri(34037, 10241, 9728);
        gl.glTexParameteri(34037, 10240, 9728);
        gl.glBindTexture(34037, 0);
    }

    public static void setLinear(PIVideoBuffer vb, GL gl) {
        gl.glBindTexture(34037, vb.getTexture());
        gl.glTexParameteri(34037, 10241, 9729);
        gl.glTexParameteri(34037, 10240, 9729);
        gl.glBindTexture(34037, 0);
    }

    public static void setClampToEdge(PIVideoBuffer vb, GL gl) {
        gl.glBindTexture(34037, vb.getTexture());
        gl.glTexParameteri(34037, 10242, 33071);
        gl.glTexParameteri(34037, 10243, 33071);
        gl.glBindTexture(34037, 0);
    }

    public static void setClampToBorder(PIVideoBuffer vb, GL gl) {
        gl.glBindTexture(34037, vb.getTexture());
        gl.glTexParameteri(34037, 10242, 33069);
        gl.glTexParameteri(34037, 10243, 33069);
        gl.glBindTexture(34037, 0);
    }

    public static void clearTexture(PIVideoBuffer vb, GL gl) {
        if (vb.isArray()) {
            throw new IllegalArgumentException();
        }
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, vb.getTexture(), 0);
        gl.glDrawBuffer(36064);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClear(16384);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
    }

    private VideoEffectUtil() {
    }
}

