/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.plugin.PIAnimatableBoolean;
import ch.kuramo.javie.api.plugin.PIAnimatableDouble;
import ch.kuramo.javie.api.plugin.PIAnimatableEnum;
import ch.kuramo.javie.api.plugin.PIAnimatableInteger;
import ch.kuramo.javie.api.plugin.PIAnimatableValue;
import ch.kuramo.javie.api.plugin.PIShaderRegistry;
import ch.kuramo.javie.api.plugin.PIVideoBuffer;
import ch.kuramo.javie.api.plugin.PIVideoRenderContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.blurSharpen.BlurDimensions;
import ch.kuramo.javie.effects.blurSharpen.BlurUtil;
import com.google.inject.Inject;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.BoxBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class BoxBlur {
    @Property
    private PIAnimatableDouble blurriness;
    @Property(value="1")
    private PIAnimatableInteger iterations;
    @Property
    private PIAnimatableEnum<BlurDimensions> blurDimensions;
    @Property
    private PIAnimatableBoolean repeatEdgePixels;
    @Property(value="true")
    private PIAnimatableBoolean fast;
    private final PIVideoRenderContext context;
    private final PIShaderRegistry shaders;

    @Inject
    public BoxBlur(PIVideoRenderContext context, PIShaderRegistry shaders) {
        this.context = context;
        this.shaders = shaders;
    }

    public VideoBounds getVideoBounds() {
        double blur = Math.max(0.0, Math.min(500.0, (Double)this.context.value((PIAnimatableValue)this.blurriness)));
        if (blur == 0.0) {
            return null;
        }
        if (((Boolean)this.context.value((PIAnimatableValue)this.repeatEdgePixels)).booleanValue()) {
            return null;
        }
        int iterations = Math.max(1, Math.min(50, (Integer)this.context.value((PIAnimatableValue)this.iterations)));
        BlurDimensions dimensions = (BlurDimensions)((Object)this.context.value(this.blurDimensions));
        boolean horz = dimensions != BlurDimensions.VERTICAL;
        boolean vert = dimensions != BlurDimensions.HORIZONTAL;
        boolean fast = blur > 50.0 || (Boolean)this.context.value((PIAnimatableValue)this.fast) != false;
        blur = this.context.getRenderResolution().scale(blur);
        VideoBounds bounds = this.context.getPreviousBounds();
        int i = 0;
        while (i < iterations) {
            bounds = this.calcVideoBounds(bounds, blur, horz, vert, fast);
            ++i;
        }
        return bounds;
    }

    private VideoBounds calcVideoBounds(VideoBounds bounds, double blur, boolean horz, boolean vert, boolean fast) {
        int sampleRatio = 1;
        if (fast) {
            int[] nArray = BlurUtil.getDownSampleFactors(blur);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int factor = nArray[n2];
                int hFactor = horz ? factor : 1;
                int vFactor = vert ? factor : 1;
                bounds = new VideoBounds(bounds.x / (double)hFactor, bounds.y / (double)vFactor, (bounds.width + hFactor - 1) / hFactor, (bounds.height + vFactor - 1) / vFactor);
                sampleRatio *= factor;
                ++n2;
            }
            if (sampleRatio != 1) {
                blur /= (double)sampleRatio;
                blur -= 0.3333333333333333;
            }
        }
        int radius = (int)Math.ceil(blur);
        bounds = VideoEffectUtil.expandBounds(bounds, radius, horz, vert);
        int hRatio = horz ? sampleRatio : 1;
        int vRatio = vert ? sampleRatio : 1;
        return new VideoBounds(bounds.x * (double)hRatio, bounds.y * (double)vRatio, bounds.width * hRatio, bounds.height * vRatio);
    }

    public PIVideoBuffer doVideoEffect() {
        double blur = Math.max(0.0, Math.min(500.0, (Double)this.context.value((PIAnimatableValue)this.blurriness)));
        if (blur == 0.0) {
            return null;
        }
        boolean repeatEdgePixels = (Boolean)this.context.value((PIAnimatableValue)this.repeatEdgePixels);
        int iterations = Math.max(1, Math.min(50, (Integer)this.context.value((PIAnimatableValue)this.iterations)));
        BlurDimensions dimensions = (BlurDimensions)((Object)this.context.value(this.blurDimensions));
        boolean horz = dimensions != BlurDimensions.VERTICAL;
        boolean vert = dimensions != BlurDimensions.HORIZONTAL;
        boolean fast = blur > 50.0 || (Boolean)this.context.value((PIAnimatableValue)this.fast) != false;
        blur = this.context.getRenderResolution().scale(blur);
        PIVideoBuffer buffer = this.context.doPreviousEffect();
        int i = 0;
        while (i < iterations) {
            buffer = this.doBoxBlur(buffer, blur, repeatEdgePixels, horz, vert, fast);
            ++i;
        }
        return buffer;
    }

    private PIVideoBuffer doBoxBlur(PIVideoBuffer input, double blur, boolean repeatEdgePixels, boolean horz, boolean vert, boolean fast) {
        GL gl = this.context.getGL();
        GLU glu = this.context.getGLU();
        VideoBounds inputBounds = input.getBounds();
        int sampleRatio = 1;
        if (fast) {
            VideoBounds bounds = inputBounds;
            int[] nArray = BlurUtil.getDownSampleFactors(blur);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int factor = nArray[n2];
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                }
                int hFactor = horz ? factor : 1;
                int vFactor = vert ? factor : 1;
                bounds = new VideoBounds(bounds.x / (double)hFactor, bounds.y / (double)vFactor, (bounds.width + hFactor - 1) / hFactor, (bounds.height + vFactor - 1) / vFactor);
                PIVideoBuffer buf = this.context.createVideoBuffer(bounds);
                BlurUtil.doDownSample(input, buf, hFactor, vFactor, gl, glu, this.shaders);
                input.dispose();
                input = buf;
                sampleRatio *= factor;
                ++n2;
            }
            if (sampleRatio != 1) {
                blur /= (double)sampleRatio;
                blur -= 0.3333333333333333;
            }
        }
        int radius = (int)Math.ceil(blur);
        float[] kernel = new float[radius * 2 + 1];
        Arrays.fill(kernel, (float)(1.0 / (blur * 2.0 + 1.0)));
        if (blur != (double)radius) {
            kernel[0] = (float)((double)kernel[0] * (1.0 - ((double)radius - blur)));
            int n = kernel.length - 1;
            kernel[n] = (float)((double)kernel[n] * (1.0 - ((double)radius - blur)));
        }
        PIVideoBuffer buf1 = null;
        PIVideoBuffer buf2 = null;
        PIVideoBuffer buf3 = null;
        try {
            if (horz) {
                VideoBounds bounds = input.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, true, false);
                }
                buf1 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(input, buf1, true, radius, kernel, gl, glu, this.shaders);
            } else {
                buf1 = input;
                input = null;
            }
            if (vert) {
                VideoBounds bounds = buf1.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf1, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, false, true);
                }
                buf2 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(buf1, buf2, false, radius, kernel, gl, glu, this.shaders);
            } else {
                buf2 = buf1;
                buf1 = null;
            }
            if (sampleRatio != 1) {
                VideoBounds bounds;
                int vRatio;
                int hRatio = horz ? sampleRatio : 1;
                int n = vRatio = vert ? sampleRatio : 1;
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf2, gl);
                    bounds = inputBounds;
                } else {
                    bounds = buf2.getBounds();
                    bounds = new VideoBounds(bounds.x * (double)hRatio, bounds.y * (double)vRatio, bounds.width * hRatio, bounds.height * vRatio);
                }
                buf3 = this.context.createVideoBuffer(bounds);
                BlurUtil.doUpSample(buf2, buf3, hRatio, vRatio, gl, glu);
            } else {
                buf3 = buf2;
                buf2 = null;
            }
            PIVideoBuffer pIVideoBuffer = buf3;
            return pIVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buf1 != null) {
                buf1.dispose();
            }
            if (buf2 != null) {
                buf2.dispose();
            }
        }
    }
}

