/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.colorCorrection;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.GLProgram;
import ch.kuramo.javie.api.annotations.GLShader;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.plugin.PIAnimatableColor;
import ch.kuramo.javie.api.plugin.PIAnimatableDouble;
import ch.kuramo.javie.api.plugin.PIAnimatableValue;
import ch.kuramo.javie.api.plugin.PIShaderProgram;
import ch.kuramo.javie.api.plugin.PIShaderRegistry;
import ch.kuramo.javie.api.plugin.PIVideoBuffer;
import ch.kuramo.javie.api.plugin.PIVideoRenderContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.Tritone", category="ch.kuramo.javie.api.effectCategory.colorCorrection")
public class Tritone {
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram
    public static final String[] TRITONE = new String[]{"uniform sampler2DRect texture;", "uniform vec3 highlight;", "uniform vec3 midtone;", "uniform vec3 shadow;", "uniform float blend;", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 src = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat y = dot(src.rgb/src.a, yvec);", "\tvec3 rgb;", "\tif (y > 0.5) {", "\t\tfloat y2 = (y-0.5)*2.0;", "\t\trgb = highlight*y2 + midtone*(1.0-y2);", "\t} else {", "\t\tfloat y2 = y*2.0;", "\t\trgb = shadow*(1.0-y2) + midtone*y2;", "\t}", "\tfloat a = src.a*(1.0-blend);", "\tgl_FragColor = src*blend + vec4(rgb*a, a);", "}"};
    private final PIVideoRenderContext context;
    private final PIShaderProgram tritoneProgram;
    @Property(value="1.0,1.0,1.0")
    private PIAnimatableColor highlight;
    @Property(value="0.499,0.393,0.275")
    private PIAnimatableColor midtone;
    @Property(value="0.0,0.0,0.0")
    private PIAnimatableColor shadow;
    @Property(value="0.0")
    private PIAnimatableDouble blendWithOriginal;

    @Inject
    public Tritone(PIVideoRenderContext context, PIShaderRegistry shaders) {
        this.context = context;
        this.tritoneProgram = shaders.getProgram(Tritone.class, "TRITONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIVideoBuffer doVideoEffect() {
        double blend = Math.max(0.0, Math.min(1.0, (Double)this.context.value((PIAnimatableValue)this.blendWithOriginal) / 100.0));
        if (blend == 1.0) {
            return null;
        }
        Color highlight = (Color)this.context.value((PIAnimatableValue)this.highlight);
        Color midtone = (Color)this.context.value((PIAnimatableValue)this.midtone);
        Color shadow = (Color)this.context.value((PIAnimatableValue)this.shadow);
        PIVideoBuffer input = this.context.doPreviousEffect();
        PIVideoBuffer buf = null;
        try {
            VideoBounds bounds = input.getBounds();
            int w = bounds.width;
            int h = bounds.height;
            buf = this.context.createVideoBuffer(bounds);
            GL gl = this.context.getGL();
            GLU glu = this.context.getGLU();
            VideoEffectUtil.ortho2D(gl, glu, w, h);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, buf.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            PIShaderProgram pIShaderProgram = this.tritoneProgram;
            synchronized (pIShaderProgram) {
                gl.glUseProgram(this.tritoneProgram.getProgram());
                gl.glUniform1i(this.tritoneProgram.getUniformLocation("texture"), 0);
                gl.glUniform3f(this.tritoneProgram.getUniformLocation("highlight"), (float)highlight.r, (float)highlight.g, (float)highlight.b);
                gl.glUniform3f(this.tritoneProgram.getUniformLocation("midtone"), (float)midtone.r, (float)midtone.g, (float)midtone.b);
                gl.glUniform3f(this.tritoneProgram.getUniformLocation("shadow"), (float)shadow.r, (float)shadow.g, (float)shadow.b);
                gl.glUniform1f(this.tritoneProgram.getUniformLocation("blend"), (float)blend);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)w, 0.0f);
                gl.glVertex2f((float)w, 0.0f);
                gl.glTexCoord2f((float)w, (float)h);
                gl.glVertex2f((float)w, (float)h);
                gl.glTexCoord2f(0.0f, (float)h);
                gl.glVertex2f(0.0f, (float)h);
                gl.glEnd();
                gl.glFinish();
                gl.glUseProgram(0);
            }
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
            PIVideoBuffer output = buf;
            buf = null;
            PIVideoBuffer pIVideoBuffer = output;
            return pIVideoBuffer;
        }
        finally {
            input.dispose();
            if (buf != null) {
                buf.dispose();
            }
        }
    }
}

