/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.utility;

import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.plugin.PIAnimatableInteger;
import ch.kuramo.javie.api.plugin.PIAnimatableValue;
import ch.kuramo.javie.api.plugin.PIVideoBuffer;
import ch.kuramo.javie.api.plugin.PIVideoRenderContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.ChangeBounds", category="ch.kuramo.javie.api.effectCategory.utility")
public class ChangeBounds {
    private final PIVideoRenderContext context;
    @Property
    private PIAnimatableInteger left;
    @Property
    private PIAnimatableInteger top;
    @Property
    private PIAnimatableInteger right;
    @Property
    private PIAnimatableInteger bottom;

    @Inject
    public ChangeBounds(PIVideoRenderContext context) {
        this.context = context;
    }

    public VideoBounds getVideoBounds() {
        RenderResolution resolution = this.context.getRenderResolution();
        int left = (int)resolution.scale((double)((Integer)this.context.value((PIAnimatableValue)this.left)).intValue());
        int top = (int)resolution.scale((double)((Integer)this.context.value((PIAnimatableValue)this.top)).intValue());
        int right = (int)resolution.scale((double)((Integer)this.context.value((PIAnimatableValue)this.right)).intValue());
        int bottom = (int)resolution.scale((double)((Integer)this.context.value((PIAnimatableValue)this.bottom)).intValue());
        VideoBounds bounds = this.context.getPreviousBounds();
        return new VideoBounds(bounds.x - (double)left, bounds.y - (double)top, Math.max(0, bounds.width + left + right), Math.max(0, bounds.height + top + bottom));
    }

    public PIVideoBuffer doVideoEffect() {
        RenderResolution resolution = this.context.getRenderResolution();
        int left = (int)resolution.scale((double)((Integer)this.context.value((PIAnimatableValue)this.left)).intValue());
        int top = (int)resolution.scale((double)((Integer)this.context.value((PIAnimatableValue)this.top)).intValue());
        int right = (int)resolution.scale((double)((Integer)this.context.value((PIAnimatableValue)this.right)).intValue());
        int bottom = (int)resolution.scale((double)((Integer)this.context.value((PIAnimatableValue)this.bottom)).intValue());
        PIVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds oldBounds = input.getBounds();
        VideoBounds newBounds = new VideoBounds(oldBounds.x - (double)left, oldBounds.y - (double)top, Math.max(0, oldBounds.width + left + right), Math.max(0, oldBounds.height + top + bottom));
        if (newBounds.equals((Object)oldBounds)) {
            return input;
        }
        PIVideoBuffer buffer = this.context.createVideoBuffer(newBounds);
        try {
            GL gl = this.context.getGL();
            GLU glu = this.context.getGLU();
            VideoEffectUtil.clearTexture(buffer, gl);
            VideoEffectUtil.ortho2D(gl, glu, newBounds.width, newBounds.height);
            gl.glMatrixMode(5888);
            gl.glTranslatef((float)left, (float)top, 0.0f);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            gl.glEnable(34037);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            int w = oldBounds.width;
            int h = oldBounds.height;
            gl.glBegin(7);
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord2f((float)w, 0.0f);
            gl.glVertex2f((float)w, 0.0f);
            gl.glTexCoord2f((float)w, (float)h);
            gl.glVertex2f((float)w, (float)h);
            gl.glTexCoord2f(0.0f, (float)h);
            gl.glVertex2f(0.0f, (float)h);
            gl.glEnd();
            gl.glDisable(34037);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
            PIVideoBuffer output = buffer;
            buffer = null;
            PIVideoBuffer pIVideoBuffer = output;
            return pIVideoBuffer;
        }
        finally {
            input.dispose();
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }
}

