/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractTransformableLayer;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.BlendMode;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.VideoLayerComposer;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.internal.VideoLayerBufferImpl;
import ch.kuramo.javie.core.services.AudioEffectPipeline;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMediaLayer
extends AbstractTransformableLayer
implements MediaLayer {
    private boolean _videoNature;
    private boolean _audioNature;
    private boolean _videoEnabled;
    private boolean _audioEnabled;
    private boolean _effectsEnabled = true;
    private List<Effect> _effects = Util.newList();
    private TrackMatte _trackMatte = TrackMatte.NONE;
    private AnimatableVec2d _depthBase = new AnimatableVec2d(new Vec2d(0.0, 0.0));
    private AnimatableString _intersectionGroup = new AnimatableString("");
    private AnimatableDouble _opacity = new AnimatableDouble(100.0);
    private BlendMode _blendMode = BlendMode.NORMAL;
    private AnimatableVec2d _audioLevels = new AnimatableVec2d(new Vec2d(0.0, 0.0));
    private AnimatableDouble _timeRemap = new AnimatableDouble(0.0);
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private VideoEffectPipeline _vePipeline;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private AudioEffectPipeline _aePipeline;

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Use initialize(boolean, boolean) method instead.");
    }

    protected void initialize(boolean videoAvailable, boolean audioAvailable) {
        if (!videoAvailable && !audioAvailable) {
            throw new IllegalArgumentException();
        }
        super.initialize();
        if (videoAvailable) {
            this._videoNature = true;
            this._videoEnabled = true;
        }
        if (audioAvailable) {
            this._audioNature = true;
            this._audioEnabled = true;
        }
    }

    @Override
    public boolean isVideoNature() {
        return this._videoNature;
    }

    public void setVideoNature(boolean videoNature) {
        this._videoNature = videoNature;
    }

    @Override
    public boolean isAudioNature() {
        return this._audioNature;
    }

    public void setAudioNature(boolean audioNature) {
        this._audioNature = audioNature;
    }

    @Override
    public boolean isVideoEnabled() {
        return this._videoEnabled;
    }

    @Override
    public void setVideoEnabled(boolean enabled) {
        this._videoEnabled = enabled;
    }

    @Override
    public boolean isAudioEnabled() {
        return this._audioEnabled;
    }

    @Override
    public void setAudioEnabled(boolean enabled) {
        this._audioEnabled = enabled;
    }

    @Override
    public boolean isEffectsEnabled() {
        return this._effectsEnabled;
    }

    @Override
    public void setEffectsEnabled(boolean effectsEnabled) {
        this._effectsEnabled = effectsEnabled;
    }

    @Override
    public List<Effect> getEffects() {
        return this._effects;
    }

    public void setEffects(List<Effect> effects) {
        this._effects = effects;
    }

    @Override
    public TrackMatte getTrackMatte() {
        return this._trackMatte;
    }

    @Override
    public void setTrackMatte(TrackMatte trackMatte) {
        this._trackMatte = trackMatte;
    }

    @Override
    public AnimatableVec2d getDepthBase() {
        return this._depthBase;
    }

    public void setDepthBase(AnimatableVec2d depthBase) {
        this._depthBase = depthBase;
    }

    @Override
    public AnimatableString getIntersectionGroup() {
        return this._intersectionGroup;
    }

    public void setIntersectionGroup(AnimatableString intersectionGroup) {
        this._intersectionGroup = intersectionGroup;
    }

    @Override
    public AnimatableDouble getOpacity() {
        return this._opacity;
    }

    public void setOpacity(AnimatableDouble opacity) {
        this._opacity = opacity;
    }

    @Override
    public BlendMode getBlendMode() {
        return this._blendMode;
    }

    @Override
    public void setBlendMode(BlendMode blendMode) {
        this._blendMode = blendMode;
    }

    @Override
    public AnimatableVec2d getAudioLevels() {
        return this._audioLevels;
    }

    public void setAudioLevels(AnimatableVec2d audioLevels) {
        this._audioLevels = audioLevels;
    }

    @Override
    public AnimatableDouble getTimeRemap() {
        return this._timeRemap;
    }

    public void setTimeRemap(AnimatableDouble timeRemap) {
        this._timeRemap = timeRemap;
    }

    @Override
    public boolean isVectorLayer() {
        return this.getMediaInput() instanceof VectorMediaInput;
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this._depthBase);
        scope.assignTo(this._intersectionGroup);
        scope.assignTo(this._opacity);
        scope.assignTo(this._audioLevels);
        scope.assignTo(this._timeRemap);
        for (Effect effect : this._effects) {
            effect.prepareExpression(scope.clone());
        }
    }

    @Override
    public void setupVideoRenderer(VideoLayerComposer composer, Camera camera, CollapseTransformation ct) {
        MediaInput input = this.getMediaInput();
        if (input == null || !input.isVideoAvailable()) {
            return;
        }
        if (this.isVectorLayer() && LayerNature.isCTCR(this)) {
            this.setupVideoRendererCR(composer, camera, ct);
        } else {
            this.setupVideoRendererNormal(composer, camera, ct);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMediaTime(RenderContext context, MediaInput input) {
        Time time;
        if (LayerNature.isTimeRemapEnabled(this)) {
            if (context == this._vrContext) {
                Time frameDuration = input.getVideoFrameDuration();
                int timeScale = frameDuration.timeScale;
                double t0 = (Double)this._timeRemap.value(context);
                double t1 = (Double)this._timeRemap.valueAtTime(context.getTime().add(frameDuration), context);
                time = new Time(Math.round(t0 * (double)timeScale), timeScale);
                if (t0 > t1) {
                    time = time.subtract(frameDuration);
                }
            } else {
                if (context != this._arContext) throw new IllegalArgumentException();
                int timeScale = this._arContext.getAudioMode().sampleRate;
                time = new Time(Math.round((Double)this._timeRemap.value(context) * (double)timeScale), timeScale);
            }
        } else {
            time = context.getTime().subtract(this.getStartTime());
            double rate = this.getRate();
            if (rate != 1.0) {
                time = new Time(Math.round((double)time.timeValue * rate), time.timeScale);
                if (rate < 0.0) {
                    time = time.add(input.getDuration());
                    if (context == this._vrContext) {
                        Time frameDuration = input.getVideoFrameDuration();
                        time = time.subtract(frameDuration);
                    } else if (context != this._arContext) {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        context.setTime(time);
    }

    private void setupVideoRendererNormal(VideoLayerComposer composer, final Camera camera, CollapseTransformation ct) {
        final MediaInput input = this.getMediaInput();
        RenderResolution resolution = this._vrContext.getRenderResolution();
        VideoBounds bounds = this._vePipeline.getVideoBounds(this._effectsEnabled ? this._effects : Collections.emptyList(), resolution.scale(input.getVideoFrameBounds()));
        Vec2d offset = new Vec2d(-bounds.x / resolution.scale, -bounds.y / resolution.scale);
        final double[] mvMatrix = new double[16];
        final double[] prjMatrix = new double[16];
        this.createMatrix(camera, ct, offset, mvMatrix, prjMatrix);
        final double opacity = ct == null ? (Double)this._opacity.value(this._vrContext) / 100.0 : (Double)this._opacity.value(this._vrContext) / 100.0 * ct.getOpacity();
        VideoLayerRenderer r = new VideoLayerRenderer(){

            public VideoLayerBuffer render(boolean withDepthBuffer) {
                VideoBuffer effectedBuffer = null;
                try {
                    VideoBuffer inputBuffer = AbstractMediaLayer.this._vrContext.saveAndExecute(new WrappedOperation<VideoBuffer>(){

                        @Override
                        public VideoBuffer execute() {
                            AbstractMediaLayer.this.setMediaTime(AbstractMediaLayer.this._vrContext, input);
                            return input.getVideoFrameImage();
                        }
                    });
                    effectedBuffer = AbstractMediaLayer.this._vePipeline.doVideoEffects(AbstractMediaLayer.this._effectsEnabled ? AbstractMediaLayer.this._effects : Collections.emptyList(), inputBuffer);
                    VideoBuffer trnsfrmdBuffer = AbstractMediaLayer.this._vrSupport.createVideoBuffer(AbstractMediaLayer.this._vrContext.getColorMode(), camera.getViewportSize());
                    trnsfrmdBuffer.allocateAsTexture();
                    trnsfrmdBuffer.clear();
                    DepthBuffer depthBuffer = withDepthBuffer ? AbstractMediaLayer.this._vrSupport.createDepthBuffer(camera.getViewportSize()) : null;
                    AbstractMediaLayer.this._vrSupport.transform(effectedBuffer, trnsfrmdBuffer, depthBuffer, mvMatrix, prjMatrix);
                    VideoLayerBufferImpl videoLayerBufferImpl = new VideoLayerBufferImpl(trnsfrmdBuffer, depthBuffer, AbstractMediaLayer.this._blendMode, opacity);
                    return videoLayerBufferImpl;
                }
                finally {
                    if (effectedBuffer != null) {
                        effectedBuffer.dispose();
                    }
                }
            }
        };
        if (LayerNature.isThreeD(this)) {
            Vec2d depthBase2d = (Vec2d)this._depthBase.value(this._vrContext);
            Vec3d depthBase = new Vec3d(depthBase2d.x + offset.x, depthBase2d.y + offset.y);
            depthBase = resolution.scale(depthBase);
            Size2i vp = camera.getViewportSize();
            Vec3d[] vertices = new Vec3d[]{this._vrSupport.project(depthBase, mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp)};
            composer.add3D(r, vertices, (String)this._intersectionGroup.value(this._vrContext));
        } else {
            composer.add2D(r);
        }
    }

    private void setupVideoRendererCR(VideoLayerComposer composer, final Camera camera, CollapseTransformation ct) {
        final VectorMediaInput input = (VectorMediaInput)this.getMediaInput();
        RenderResolution resolution = this._vrContext.getRenderResolution();
        VideoBounds bounds = resolution.scale(input.getVideoFrameBounds());
        final double[] mvMatrix = new double[16];
        final double[] prjMatrix = new double[16];
        this.createMatrix(camera, ct, null, mvMatrix, prjMatrix);
        final double opacity = ct == null ? (Double)this._opacity.value(this._vrContext) / 100.0 : (Double)this._opacity.value(this._vrContext) / 100.0 * ct.getOpacity();
        VideoLayerRenderer r = new VideoLayerRenderer(){

            public VideoLayerBuffer render(boolean withDepthBuffer) {
                final VideoBuffer rasterBuffer = AbstractMediaLayer.this._vrSupport.createVideoBuffer(AbstractMediaLayer.this._vrContext.getColorMode(), camera.getViewportSize());
                rasterBuffer.allocateAsTexture();
                rasterBuffer.clear();
                final DepthBuffer depthBuffer = withDepthBuffer ? AbstractMediaLayer.this._vrSupport.createDepthBuffer(camera.getViewportSize()) : null;
                AbstractMediaLayer.this._vrContext.saveAndExecute(new WrappedOperation<Object>(){

                    @Override
                    public Object execute() {
                        AbstractMediaLayer.this.setMediaTime(AbstractMediaLayer.this._vrContext, input);
                        input.rasterize(rasterBuffer, depthBuffer, mvMatrix, prjMatrix);
                        return null;
                    }
                });
                return new VideoLayerBufferImpl(rasterBuffer, depthBuffer, AbstractMediaLayer.this._blendMode, opacity);
            }
        };
        if (LayerNature.isThreeD(this)) {
            Vec2d depthBase2d = (Vec2d)this._depthBase.value(this._vrContext);
            Vec3d depthBase = new Vec3d(depthBase2d.x, depthBase2d.y);
            depthBase = resolution.scale(depthBase);
            Size2i vp = camera.getViewportSize();
            Vec3d[] vertices = new Vec3d[]{this._vrSupport.project(depthBase, mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp)};
            composer.add3D(r, vertices, (String)this._intersectionGroup.value(this._vrContext));
        } else {
            composer.add2D(r);
        }
    }

    private void createMatrix(final Camera camera, final CollapseTransformation ct, final Vec2d offset, final double[] mvMatrix, final double[] prjMatrix) {
        WrappedOperation<Object> operation = new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                if (camera == null) {
                    AbstractMediaLayer.this._vrSupport.resetMatrix();
                } else if (LayerNature.isThreeD(AbstractMediaLayer.this)) {
                    AbstractMediaLayer.this._vrSupport.setMatrix(camera.getModelView3D(), camera.getProjection3D());
                } else {
                    AbstractMediaLayer.this._vrSupport.setMatrix(camera.getModelView2D(), camera.getProjection2D());
                }
                LayerMatrixUtil.multModelViewMatrix(AbstractMediaLayer.this, offset, ct, AbstractMediaLayer.this._vrContext, AbstractMediaLayer.this._vrSupport);
                AbstractMediaLayer.this._vrSupport.getMatrix(mvMatrix, prjMatrix);
                return null;
            }
        };
        this._vrSupport.pushMatrixAndExecute(operation);
    }

    @Override
    public AudioBuffer renderAudioChunk() {
        if (!LayerNature.isAudioEnabled(this)) {
            return null;
        }
        final MediaInput input = this.getMediaInput();
        if (input == null || !input.isAudioAvailable()) {
            return null;
        }
        AudioBuffer ab = this._arContext.saveAndExecute(new WrappedOperation<AudioBuffer>(){

            @Override
            public AudioBuffer execute() {
                AbstractMediaLayer.this.setMediaTime(AbstractMediaLayer.this._arContext, input);
                return input.getAudioChunk();
            }
        });
        if (ab == null) {
            return null;
        }
        ab = this._aePipeline.doAudioEffects(this._effectsEnabled ? this._effects : Collections.emptyList(), ab);
        Vec2d audioLevels = (Vec2d)this._audioLevels.value(this._arContext);
        if (audioLevels.x != 0.0 || audioLevels.y != 0.0) {
            this._arSupport.amplify(ab, audioLevels);
        }
        Time time = this._arContext.getTime();
        Time sampleDuration = this._arContext.getAudioMode().sampleDuration;
        int clearFrameCount = (int)this.getInPoint().subtract(time).toFrameNumber(sampleDuration);
        if (clearFrameCount > 0) {
            this._arSupport.clear(ab, 0, clearFrameCount);
        }
        int clearFrameOffset = (int)this.getOutPoint().subtract(time).toFrameNumber(sampleDuration);
        clearFrameCount = this._arContext.getFrameCount() - clearFrameOffset;
        if (clearFrameCount > 0) {
            this._arSupport.clear(ab, clearFrameOffset, clearFrameCount);
        }
        return ab;
    }

    @Override
    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        super.afterDecode(p, c);
        for (Effect effect : this._effects) {
            effect.afterDecode(p);
        }
    }

    @Override
    public Object createExpressionElement(RenderContext renderContext) {
        return new MediaLayerExpressionElement(renderContext);
    }

    public class MediaLayerExpressionElement
    extends AbstractTransformableLayer.TransformableLayerExpressionElement {
        public MediaLayerExpressionElement(RenderContext renderContext) {
            super(renderContext);
        }

        public Object getDepthBase() {
            return this.elem(AbstractMediaLayer.this._depthBase);
        }

        public Object getIntersectionGroup() {
            return this.elem(AbstractMediaLayer.this._intersectionGroup);
        }

        public Object getOpacity() {
            return this.elem(AbstractMediaLayer.this._opacity);
        }

        public Object getAudioLevels() {
            return this.elem(AbstractMediaLayer.this._audioLevels);
        }

        public Object getTimeRemap() {
            return LayerNature.isTimeRemapEnabled(AbstractMediaLayer.this) ? this.elem(AbstractMediaLayer.this._timeRemap) : null;
        }

        public Object effect(int index) {
            Effect effect = (Effect)AbstractMediaLayer.this._effects.get(index - 1);
            return this.renderContext.getExpressionElement(effect);
        }
    }
}

