/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

class CameraImpl
implements Camera {
    private final VideoRenderContext _vrContext;
    private final VideoRenderSupport _vrSupport;
    private final CameraLayer _cameraLayer;
    private final Size2i _compSize;
    private final Size2i _viewportSize;
    private final double[] _mvMatrix2D;
    private final double[] _prjMatrix2D;
    private final Map<Time, double[][]> _matrix3DCache;

    CameraImpl(VideoRenderContext vrContext, VideoRenderSupport vrSupport, CameraLayer cameraLayer, Size2i compSize, Size2i viewportSize) {
        this._vrContext = vrContext;
        this._vrSupport = vrSupport;
        this._cameraLayer = cameraLayer;
        this._compSize = compSize;
        this._viewportSize = viewportSize;
        this._mvMatrix2D = new double[16];
        this._prjMatrix2D = new double[16];
        this._matrix3DCache = Util.newMap();
        this.createMatrix2D();
    }

    private void createMatrix2D() {
        GL gl = this._vrContext.getGL();
        GLU glu = this._vrContext.getGLU();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0, (double)this._viewportSize.width, 0.0, (double)this._viewportSize.height);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this._vrSupport.getMatrix(this._mvMatrix2D, this._prjMatrix2D);
    }

    public Size2i getViewportSize() {
        return this._viewportSize;
    }

    public double[] getModelView2D() {
        return this._mvMatrix2D;
    }

    public double[] getProjection2D() {
        return this._prjMatrix2D;
    }

    public double[] getModelView3D() {
        return this.getMatrix3D()[0];
    }

    public double[] getProjection3D() {
        return this.getMatrix3D()[1];
    }

    private double[][] getMatrix3D() {
        Time time = this._vrContext.getTime();
        double[][] matrix = this._matrix3DCache.get(time);
        if (matrix != null) {
            return matrix;
        }
        matrix = this._vrSupport.pushMatrixAndExecute(new WrappedOperation<double[][]>(){

            @Override
            public double[][] execute() {
                double far;
                double near;
                double fovy;
                double zoom;
                Vec3d pointOfInterest;
                Vec3d position;
                Vec3d rotation;
                Vec3d orientation;
                double aspect = (double)((CameraImpl)CameraImpl.this)._viewportSize.width / (double)((CameraImpl)CameraImpl.this)._viewportSize.height;
                if (CameraImpl.this._cameraLayer != null) {
                    orientation = (Vec3d)CameraImpl.this._cameraLayer.getOrientation().value(CameraImpl.this._vrContext);
                    rotation = new Vec3d(((Double)CameraImpl.this._cameraLayer.getRotationX().value(CameraImpl.this._vrContext)).doubleValue(), ((Double)CameraImpl.this._cameraLayer.getRotationY().value(CameraImpl.this._vrContext)).doubleValue(), ((Double)CameraImpl.this._cameraLayer.getRotationZ().value(CameraImpl.this._vrContext)).doubleValue());
                    position = (Vec3d)CameraImpl.this._cameraLayer.getPosition().value(CameraImpl.this._vrContext);
                    pointOfInterest = (Vec3d)CameraImpl.this._cameraLayer.getPointOfInterest().value(CameraImpl.this._vrContext);
                    zoom = (Double)CameraImpl.this._cameraLayer.getZoom().value(CameraImpl.this._vrContext);
                    fovy = Math.toDegrees(2.0 * Math.atan((double)((CameraImpl)CameraImpl.this)._compSize.height / (2.0 * zoom)));
                    near = (Double)CameraImpl.this._cameraLayer.getNear().value(CameraImpl.this._vrContext);
                    far = (Double)CameraImpl.this._cameraLayer.getFar().value(CameraImpl.this._vrContext);
                } else {
                    zoom = CameraImpl.this.getDefaultZoom();
                    fovy = Math.toDegrees(2.0 * Math.atan((double)((CameraImpl)CameraImpl.this)._compSize.height / (2.0 * zoom)));
                    near = zoom / 2.0;
                    far = zoom * 10.0;
                    orientation = new Vec3d(0.0, 0.0, 0.0);
                    rotation = new Vec3d(0.0, 0.0, 0.0);
                    position = new Vec3d((double)((CameraImpl)CameraImpl.this)._compSize.width / 2.0, (double)((CameraImpl)CameraImpl.this)._compSize.height / 2.0, -zoom);
                    pointOfInterest = new Vec3d(position.x, position.y, 0.0);
                }
                RenderResolution resolution = CameraImpl.this._vrContext.getRenderResolution();
                position = resolution.scale(position);
                pointOfInterest = resolution.scale(pointOfInterest);
                near = resolution.scale(near);
                far = resolution.scale(far);
                GL gl = CameraImpl.this._vrContext.getGL();
                GLU glu = CameraImpl.this._vrContext.getGLU();
                gl.glMatrixMode(5889);
                gl.glLoadIdentity();
                glu.gluPerspective(fovy, aspect, near, far);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                CameraImpl.this._vrSupport.multCameraMatrix(orientation, rotation, position, pointOfInterest, true);
                if (CameraImpl.this._cameraLayer != null) {
                    LayerMatrixUtil.multParentMatrix(CameraImpl.this._cameraLayer, CameraImpl.this._vrContext, CameraImpl.this._vrSupport);
                }
                double[][] matrix3D = new double[2][16];
                CameraImpl.this._vrSupport.getMatrix(matrix3D[0], matrix3D[1]);
                return matrix3D;
            }
        });
        this._matrix3DCache.put(time, matrix);
        return matrix;
    }

    private double getDefaultZoom() {
        double fovx = 39.6;
        return (double)this._compSize.width / (2.0 * Math.tan(Math.toRadians(fovx / 2.0)));
    }

    Vec3d getPosition() {
        return this._cameraLayer != null ? (Vec3d)this._cameraLayer.getPosition().value(this._vrContext) : new Vec3d((double)this._compSize.width / 2.0, (double)this._compSize.height / 2.0, -this.getDefaultZoom());
    }
}

