/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSoundInput
implements MediaFileInput {
    private static final Logger _logger = LoggerFactory.getLogger(JavaSoundInput.class);
    private File _file;
    private Time _duration;
    private AudioInputStream _stream;
    private long _position;
    private byte[] _buffer;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;

    public boolean initialize(File file) {
        this._file = file;
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(file);
            try {
                long numFrames = stream.getFrameLength();
                float frameRate = stream.getFormat().getFrameRate();
                int frameRateInt = (int)frameRate;
                if (frameRate - (float)frameRateInt != 0.0f) {
                    _logger.warn("frame rate is not integer: " + frameRate);
                }
                this._duration = new Time(numFrames, frameRateInt);
            }
            finally {
                stream.close();
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void dispose() {
        this.closeStream();
    }

    private void closeStream() {
        if (this._stream != null) {
            try {
                this._stream.close();
            }
            catch (IOException e) {
                _logger.warn("failed to close AudioInputStream", (Throwable)e);
            }
            this._stream = null;
        }
        this._position = 0L;
    }

    public synchronized AudioBuffer getAudioChunk() {
        try {
            Time time = this._arContext.getTime();
            AudioMode audioMode = this._arContext.getAudioMode();
            long frameNumber = time.toFrameNumber(audioMode.sampleDuration);
            if (frameNumber < this._position) {
                this.closeStream();
            }
            if (this._stream == null) {
                this._stream = this.createAudioInputStream();
            }
            return this.readAudioData(frameNumber);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private AudioInputStream createAudioInputStream() throws IOException, UnsupportedAudioFileException {
        AudioMode audioMode = this._arContext.getAudioMode();
        int bits = audioMode.sampleSize * 8;
        int ch = audioMode.channels;
        boolean bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        AudioInputStream s1 = AudioSystem.getAudioInputStream(this._file);
        AudioFormat f2 = new AudioFormat(s1.getFormat().getSampleRate(), bits, ch, true, bigEndian);
        AudioInputStream s2 = AudioSystem.getAudioInputStream(f2, s1);
        AudioFormat f3 = new AudioFormat(audioMode.sampleRate, bits, ch, true, bigEndian);
        return AudioSystem.getAudioInputStream(f3, s2);
    }

    private AudioBuffer readAudioData(long frameNumber) throws IOException {
        AudioBuffer ab = this._arSupport.createAudioBuffer();
        AudioMode audioMode = ab.getAudioMode();
        Object data = ab.getData();
        int dataOffset = 0;
        int dataLength = ab.getDataLength();
        int lengthInBytes = ab.getDataLengthInBytes();
        if (frameNumber >= 0L) {
            this._stream.skip((long)audioMode.frameSize * (frameNumber - this._position));
        } else if (this._position == 0L) {
            this._arSupport.clear(ab, 0, (int)(-frameNumber));
            dataOffset = (int)(-frameNumber) * audioMode.channels;
            dataLength -= dataOffset;
            lengthInBytes -= dataOffset * audioMode.sampleSize;
        } else {
            throw new IllegalStateException();
        }
        if (this._buffer == null || this._buffer.length < lengthInBytes) {
            this._buffer = new byte[lengthInBytes];
        }
        this._stream.read(this._buffer, 0, lengthInBytes);
        switch (audioMode.dataType) {
            case SHORT: {
                ByteBuffer.wrap(this._buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asShortBuffer().get((short[])data, dataOffset, dataLength);
                break;
            }
            case INT: {
                ByteBuffer.wrap(this._buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asIntBuffer().get((int[])data, dataOffset, dataLength);
                break;
            }
            case FLOAT: {
                int i = dataOffset;
                while (i < dataLength) {
                    int value = this._buffer[i * 4] & 0xFF | (this._buffer[i * 4 + 1] & 0xFF) << 8 | (this._buffer[i * 4 + 2] & 0xFF) << 16 | (this._buffer[i * 4 + 3] & 0xFF) << 24;
                    ((float[])data)[i] = (float)value / 2.1474836E9f;
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
            }
        }
        this._position = frameNumber + (long)ab.getFrameCount();
        return ab;
    }

    public boolean isVideoAvailable() {
        return false;
    }

    public boolean isAudioAvailable() {
        return true;
    }

    public Time getDuration() {
        return this._duration;
    }

    public Time getVideoFrameDuration() {
        throw new UnsupportedOperationException("video is not available");
    }

    public VideoBounds getVideoFrameBounds() {
        throw new UnsupportedOperationException("video is not available");
    }

    public VideoBuffer getVideoFrameImage() {
        throw new UnsupportedOperationException("video is not available");
    }
}

