/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.exprelems.StringProperty;
import ch.kuramo.javie.core.internal.AbstractMediaLayer;
import ch.kuramo.javie.core.services.FontManager;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.io.File;
import net.arnx.jsonic.JSONHint;
import org.mozilla.javascript.Scriptable;

@ProjectElement(value="textLayer")
public class TextLayerImpl
extends AbstractMediaLayer
implements TextLayer {
    private final TextInput _input = new TextInput();
    private boolean _ctcr;
    private AnimatableString _sourceText = new AnimatableString("\u30c6\u30ad\u30b9\u30c8");
    private AnimatableInteger _fontSize = new AnimatableInteger(36);
    private AnimatableColor _fillColor = new AnimatableColor(new Color(1.0, 1.0, 1.0));
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private FontManager _fontManager;
    private static final String FONTPATH;

    static {
        String[] fonts = new String[]{"C:\\WINDOWS\\Fonts\\meiryob.ttc", "C:\\WINDOWS\\Fonts\\msgoth04.ttc", "C:\\WINDOWS\\Fonts\\msgothic.ttc", "/System/Library/Fonts/\u30d2\u30e9\u30ae\u30ce\u89d2\u30b4 ProN W6.otf", "/System/Library/Fonts/\u30d2\u30e9\u30ae\u30ce\u89d2\u30b4 Pro W6.otf", "/Library/Fonts/Osaka.dfont"};
        String fontpath = "/no/font/available.ttc";
        String[] stringArray = fonts;
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (new File(f).isFile()) {
                fontpath = f;
                break;
            }
            ++n2;
        }
        FONTPATH = fontpath;
    }

    protected void initialize(boolean videoAvailable, boolean audioAvailable) {
        throw new UnsupportedOperationException("Use initialize() method instead.");
    }

    public void initialize() {
        super.initialize(true, false);
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._input;
    }

    public boolean isCTCR() {
        return this._ctcr;
    }

    public void setCTCR(boolean ctcr) {
        this._ctcr = ctcr;
    }

    public AnimatableString getSourceText() {
        return this._sourceText;
    }

    public void setSourceText(AnimatableString sourceText) {
        this._sourceText = sourceText;
    }

    public AnimatableInteger getFontSize() {
        return this._fontSize;
    }

    public void setFontSize(AnimatableInteger fontSize) {
        this._fontSize = fontSize;
    }

    public AnimatableColor getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(AnimatableColor fillColor) {
        this._fillColor = fillColor;
    }

    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this._sourceText);
        scope.assignTo(this._fontSize);
        scope.assignTo(this._fillColor);
    }

    public Object createExpressionElement(RenderContext renderContext) {
        return new TextLayerExpressionElement(renderContext);
    }

    private class TextInput
    implements VectorMediaInput {
        private TextInput() {
        }

        public void dispose() {
        }

        public boolean isVideoAvailable() {
            return true;
        }

        public boolean isAudioAvailable() {
            return false;
        }

        public Time getDuration() {
            return null;
        }

        public Time getVideoFrameDuration() {
            return null;
        }

        public VideoBounds getVideoFrameBounds() {
            if (!TextLayerImpl.this._vrContext.isActive()) {
                return null;
            }
            String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._vrContext);
            if (sourceText.length() == 0) {
                return new VideoBounds(1, 1);
            }
            float[] box = new float[6];
            FTGL.instance.ftglGetFontBBox(this.getFont(), sourceText, -1, box);
            return new VideoBounds((double)box[0], (double)(-box[4]), (int)Math.ceil(box[3] - box[0]), (int)Math.ceil(box[4] - box[1]));
        }

        public VideoBuffer getVideoFrameImage() {
            VideoBounds bounds = TextLayerImpl.this._vrContext.getRenderResolution().scale(this.getVideoFrameBounds());
            String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._vrContext);
            Color fillColor = (Color)TextLayerImpl.this._fillColor.value(TextLayerImpl.this._vrContext);
            VideoBuffer vb = TextLayerImpl.this._vrSupport.createVideoBuffer(TextLayerImpl.this._vrContext.getColorMode(), bounds);
            vb.allocateAsTexture();
            vb.clear();
            TextLayerImpl.this._vrSupport.renderText(this.getFont(), fillColor, sourceText, vb);
            return vb;
        }

        public void rasterize(VideoBuffer resultBuffer, DepthBuffer depthBuffer, double[] mvMatrix, double[] prjMatrix) {
            String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._vrContext);
            Color fillColor = (Color)TextLayerImpl.this._fillColor.value(TextLayerImpl.this._vrContext);
            TextLayerImpl.this._vrSupport.renderText(this.getFont(), fillColor, sourceText, resultBuffer, depthBuffer, mvMatrix, prjMatrix);
        }

        public AudioBuffer getAudioChunk() {
            throw new UnsupportedOperationException("audio is not available");
        }

        private FTGLfont getFont() {
            int fontSize = (Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._vrContext);
            if (TextLayerImpl.this._ctcr) {
                return TextLayerImpl.this._fontManager.getPolygonFont(FONTPATH, fontSize);
            }
            return TextLayerImpl.this._fontManager.getBufferFont(FONTPATH, fontSize);
        }
    }

    public class TextLayerExpressionElement
    extends AbstractMediaLayer.MediaLayerExpressionElement {
        public TextLayerExpressionElement(RenderContext renderContext) {
            super(renderContext);
        }

        public StringProperty getSourceText() {
            return (StringProperty)this.elem(TextLayerImpl.this._sourceText);
        }

        public Scriptable getFontSize() {
            return (Scriptable)this.elem(TextLayerImpl.this._fontSize);
        }

        public Scriptable[] getFillColor() {
            return (Scriptable[])this.elem(TextLayerImpl.this._fillColor);
        }
    }
}

