/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.plugin.PIArrayPools;
import ch.kuramo.javie.core.internal.services.ArrayPool;
import ch.kuramo.javie.core.services.ArrayPools;

public class ArrayPoolsImpl
implements ArrayPools,
PIArrayPools {
    private static final ArrayPool<byte[]> _bytePool = ArrayPool.newBytePool();
    private static final ArrayPool<short[]> _shortPool = ArrayPool.newShortPool();
    private static final ArrayPool<int[]> _intPool = ArrayPool.newIntPool();
    private static final ArrayPool<float[]> _floatPool = ArrayPool.newFloatPool();

    public byte[] getByteArray(int length) {
        return _bytePool.get(length);
    }

    public short[] getShortArray(int length) {
        return _shortPool.get(length);
    }

    public int[] getIntArray(int length) {
        return _intPool.get(length);
    }

    public float[] getFloatArray(int length) {
        return _floatPool.get(length);
    }

    public void put(byte[] array) {
        _bytePool.put(array);
    }

    public void put(short[] array) {
        _shortPool.put(array);
    }

    public void put(int[] array) {
        _intPool.put(array);
    }

    public void put(float[] array) {
        _floatPool.put(array);
    }

    public void put(Object array) {
        if (array == null) {
            return;
        }
        if (array instanceof byte[]) {
            this.put((byte[])array);
        } else if (array instanceof short[]) {
            this.put((short[])array);
        } else if (array instanceof int[]) {
            this.put((int[])array);
        } else if (array instanceof float[]) {
            this.put((float[])array);
        } else {
            throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
        }
    }
}

