/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.plugin.PIAnimatableValue;
import ch.kuramo.javie.api.plugin.PIAudioBuffer;
import ch.kuramo.javie.api.plugin.PIAudioRenderContext;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.AudioEffect;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.PIAudioRenderContextProxy;
import ch.kuramo.javie.core.services.AudioEffectPipeline;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import com.google.inject.Inject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioEffectPipelineImpl
implements AudioEffectPipeline {
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;

    @Override
    public AudioBuffer doAudioEffects(List<Effect> effects, AudioBuffer inputBuffer) {
        PIAudioRenderContextImpl impl = new PIAudioRenderContextImpl(this.enabledAudioEffectsOnly(effects), inputBuffer);
        PIAudioRenderContextProxy.push(impl);
        try {
            AudioBuffer audioBuffer = (AudioBuffer)impl.doPreviousEffect();
            return audioBuffer;
        }
        finally {
            PIAudioRenderContextProxy.pop();
        }
    }

    private List<AudioEffect> enabledAudioEffectsOnly(List<Effect> effects) {
        List<AudioEffect> audioEffects = Util.newList();
        for (Effect e : effects) {
            if (!(e instanceof AudioEffect) || !e.isEnabled()) continue;
            audioEffects.add((AudioEffect)e);
        }
        return audioEffects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PIAudioRenderContextImpl
    implements PIAudioRenderContext {
        private List<AudioEffect> effects;
        private final AudioBuffer inputBuffer;

        private PIAudioRenderContextImpl(List<AudioEffect> effects, AudioBuffer inputBuffer) {
            this.effects = effects;
            this.inputBuffer = inputBuffer;
        }

        public PIAudioBuffer doPreviousEffect() {
            if (this.effects.isEmpty()) {
                return (PIAudioBuffer)this.inputBuffer;
            }
            final AudioEffect prevEffect = this.effects.get(this.effects.size() - 1);
            return this.executePrevious(new WrappedOperation<PIAudioBuffer>(){

                @Override
                public PIAudioBuffer execute() {
                    PIAudioBuffer buffer = prevEffect.doAudioEffect();
                    return buffer != null ? buffer : PIAudioRenderContextImpl.this.doPreviousEffect();
                }
            });
        }

        private <T> T executePrevious(WrappedOperation<T> wop) {
            List<AudioEffect> savedEffects = this.effects;
            try {
                this.effects = this.effects.subList(0, this.effects.size() - 1);
                T t = AudioEffectPipelineImpl.this._arContext.saveAndExecute(wop);
                return t;
            }
            finally {
                this.effects = savedEffects;
            }
        }

        public Time getTime() {
            return AudioEffectPipelineImpl.this._arContext.getTime();
        }

        public void setTime(Time time) {
            AudioEffectPipelineImpl.this._arContext.setTime(time);
        }

        public <V> V value(PIAnimatableValue<V> avalue) {
            AnimatableValue av = (AnimatableValue)avalue;
            return av.value(AudioEffectPipelineImpl.this._arContext);
        }

        public AudioMode getAudioMode() {
            return AudioEffectPipelineImpl.this._arContext.getAudioMode();
        }

        public int getFrameCount() {
            return AudioEffectPipelineImpl.this._arContext.getFrameCount();
        }

        public void setFrameCount(int count) {
            AudioEffectPipelineImpl.this._arContext.setFrameCount(count);
        }

        public PIAudioBuffer createAudioBuffer() {
            return (PIAudioBuffer)AudioEffectPipelineImpl.this._arSupport.createAudioBuffer();
        }
    }
}

