/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.services.FontManager;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontManagerImpl
implements FontManager {
    private static final Logger logger = LoggerFactory.getLogger(FontManagerImpl.class);
    private static final FTGL ftgl = FTGL.instance;
    private static final int MAX_FONTS = 8;
    private final Map<String, FTGLfont> _fontCache = new LinkedHashMap<String, FTGLfont>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, FTGLfont> eldest) {
            if (this.size() > 8) {
                String key = eldest.getKey();
                ftgl.ftglDestroyFont(eldest.getValue());
                this.remove(key);
                logger.info("font removed from cache: " + key);
            }
            return false;
        }
    };

    void dispose() {
        for (Map.Entry<String, FTGLfont> e : this._fontCache.entrySet()) {
            ftgl.ftglDestroyFont(e.getValue());
        }
        this._fontCache.clear();
    }

    public FTGLfont getPolygonFont(String filename, int size) {
        return this.getFont(FontType.Polygon, filename, size);
    }

    public FTGLfont getOutlineFont(String filename, int size) {
        return this.getFont(FontType.Outline, filename, size);
    }

    public FTGLfont getExtrudeFont(String filename, int size) {
        return this.getFont(FontType.Extrude, filename, size);
    }

    public FTGLfont getTextureFont(String filename, int size) {
        return this.getFont(FontType.Texture, filename, size);
    }

    public FTGLfont getBufferFont(String filename, int size) {
        return this.getFont(FontType.Buffer, filename, size);
    }

    private FTGLfont getFont(FontType type, String filename, int size) {
        try {
            filename = new File(filename).getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.warn("cannot get canonical path for font: " + filename);
        }
        String key = String.format("%s,%s,%d", type.name(), filename, size);
        FTGLfont font = this._fontCache.get(key);
        if (font != null) {
            return font;
        }
        switch (type) {
            case Polygon: {
                font = ftgl.ftglCreatePolygonFont(filename);
                break;
            }
            case Outline: {
                font = ftgl.ftglCreateOutlineFont(filename);
                break;
            }
            case Extrude: {
                font = ftgl.ftglCreateExtrudeFont(filename);
                break;
            }
            case Texture: {
                font = ftgl.ftglCreateTextureFont(filename);
                break;
            }
            case Buffer: {
                font = ftgl.ftglCreateBufferFont(filename);
                break;
            }
            default: {
                throw new JavieRuntimeException("unsupported font type");
            }
        }
        int error = ftgl.ftglGetFontError(font);
        if (error != 0) {
            ftgl.ftglDestroyFont(font);
            throw new JavieRuntimeException(String.format("ftglCreate%sFont failed: error=%d", type.name(), error));
        }
        ftgl.ftglSetFontCharMap(font, 1970170211);
        ftgl.ftglSetFontFaceSize(font, size, 72);
        this._fontCache.put(key, font);
        return font;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FontType {
        Polygon,
        Outline,
        Extrude,
        Texture,
        Buffer;

    }
}

