/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.internal.services.FontManagerImpl;
import ch.kuramo.javie.core.services.FontManager;
import ftgl.FTGLfont;

public class FontManagerProxy
implements FontManager {
    private static final ThreadLocal<FontManagerImpl> _threadLocal = new ThreadLocal();

    static FontManagerImpl createImpl() {
        if (_threadLocal.get() != null) {
            throw new IllegalStateException("FontManagerImpl already exists on this thread.");
        }
        FontManagerImpl impl = new FontManagerImpl();
        _threadLocal.set(impl);
        return impl;
    }

    static void disposeImpl() {
        FontManagerImpl impl = _threadLocal.get();
        if (impl != null) {
            impl.dispose();
            _threadLocal.set(null);
        }
    }

    private FontManagerImpl getImpl() {
        FontManagerImpl impl = _threadLocal.get();
        if (impl == null) {
            throw new IllegalStateException("No FontManagerImpl exist on this thread.");
        }
        return impl;
    }

    public FTGLfont getPolygonFont(String filename, int size) {
        return this.getImpl().getPolygonFont(filename, size);
    }

    public FTGLfont getOutlineFont(String filename, int size) {
        return this.getImpl().getOutlineFont(filename, size);
    }

    public FTGLfont getExtrudeFont(String filename, int size) {
        return this.getImpl().getExtrudeFont(filename, size);
    }

    public FTGLfont getTextureFont(String filename, int size) {
        return this.getImpl().getTextureFont(filename, size);
    }

    public FTGLfont getBufferFont(String filename, int size) {
        return this.getImpl().getBufferFont(filename, size);
    }
}

