/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Util;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.NotFoundException;

class ModifiedClassLoader {
    private final Set<CtClass> _modifiedClasses = Util.newSet();

    ModifiedClassLoader() {
    }

    void add(CtClass cc) {
        this._modifiedClasses.add(cc);
    }

    void loadAll(ClassLoader cl) {
        try {
            while (!this._modifiedClasses.isEmpty()) {
                this.load(this._modifiedClasses.iterator().next(), cl);
            }
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private void load(CtClass cc, ClassLoader cl) throws NotFoundException, CannotCompileException {
        CtClass sc = cc.getSuperclass();
        if (sc != null) {
            this.load(sc, cl);
        }
        if (this._modifiedClasses.contains(cc)) {
            cc.toClass(cl, null);
            this._modifiedClasses.remove(cc);
        }
    }
}

