/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.plugin.PIShaderProgram;
import ch.kuramo.javie.core.internal.services.Uniform;
import ch.kuramo.javie.core.services.ShaderProgram;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShaderProgramImpl
implements ShaderProgram,
PIShaderProgram {
    final String name;
    final int program;
    final Map<String, Uniform> uniforms;

    ShaderProgramImpl(String name, int program, Map<String, Uniform> uniforms) {
        this.name = name;
        this.program = program;
        this.uniforms = Collections.unmodifiableMap(uniforms);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getProgram() {
        return this.program;
    }

    @Override
    public int getUniformLocation(String uniformName) {
        Uniform uniform = this.uniforms.get(uniformName);
        if (uniform == null && uniformName.endsWith("[0]")) {
            uniform = this.uniforms.get(uniformName.substring(0, uniformName.length() - 3));
        }
        return uniform != null ? uniform.location : -1;
    }
}

