/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.plugin.PIAnimatableValue;
import ch.kuramo.javie.api.plugin.PIVideoBuffer;
import ch.kuramo.javie.api.plugin.PIVideoRenderContext;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoEffect;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.PIVideoRenderContextProxy;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoEffectPipelineImpl
implements VideoEffectPipeline {
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;

    @Override
    public VideoBounds getVideoBounds(List<Effect> effects, VideoBounds inputBounds) {
        PIVideoRenderContextImpl impl = new PIVideoRenderContextImpl(this.enabledVideoEffectsOnly(effects), inputBounds);
        PIVideoRenderContextProxy.push(impl);
        try {
            VideoBounds videoBounds = impl.getPreviousBounds();
            return videoBounds;
        }
        finally {
            PIVideoRenderContextProxy.pop();
        }
    }

    @Override
    public VideoBuffer doVideoEffects(List<Effect> effects, VideoBuffer inputBuffer) {
        PIVideoRenderContextImpl impl = new PIVideoRenderContextImpl(this.enabledVideoEffectsOnly(effects), inputBuffer);
        PIVideoRenderContextProxy.push(impl);
        try {
            VideoBuffer videoBuffer = (VideoBuffer)impl.doPreviousEffect();
            return videoBuffer;
        }
        finally {
            PIVideoRenderContextProxy.pop();
        }
    }

    private List<VideoEffect> enabledVideoEffectsOnly(List<Effect> effects) {
        List<VideoEffect> videoEffects = Util.newList();
        for (Effect e : effects) {
            if (!(e instanceof VideoEffect) || !e.isEnabled()) continue;
            videoEffects.add((VideoEffect)e);
        }
        return videoEffects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PIVideoRenderContextImpl
    implements PIVideoRenderContext {
        private List<VideoEffect> effects;
        private final VideoBounds inputBounds;
        private final VideoBuffer inputBuffer;

        private PIVideoRenderContextImpl(List<VideoEffect> effects, VideoBounds inputBounds) {
            this.effects = effects;
            this.inputBounds = inputBounds;
            this.inputBuffer = null;
        }

        private PIVideoRenderContextImpl(List<VideoEffect> effects, VideoBuffer inputBuffer) {
            this.effects = effects;
            this.inputBounds = null;
            this.inputBuffer = inputBuffer;
        }

        public VideoBounds getPreviousBounds() {
            if (this.inputBounds == null) {
                throw new IllegalStateException();
            }
            if (this.effects.isEmpty()) {
                return this.inputBounds;
            }
            final VideoEffect prevEffect = this.effects.get(this.effects.size() - 1);
            return this.executePrevious(new WrappedOperation<VideoBounds>(){

                @Override
                public VideoBounds execute() {
                    VideoBounds bounds = prevEffect.getVideoBounds();
                    return bounds != null ? bounds : PIVideoRenderContextImpl.this.getPreviousBounds();
                }
            });
        }

        public PIVideoBuffer doPreviousEffect() {
            if (this.inputBuffer == null) {
                throw new IllegalStateException();
            }
            if (this.effects.isEmpty()) {
                return (PIVideoBuffer)this.inputBuffer;
            }
            final VideoEffect prevEffect = this.effects.get(this.effects.size() - 1);
            return this.executePrevious(new WrappedOperation<PIVideoBuffer>(){

                @Override
                public PIVideoBuffer execute() {
                    PIVideoBuffer buffer = prevEffect.doVideoEffect();
                    return buffer != null ? buffer : PIVideoRenderContextImpl.this.doPreviousEffect();
                }
            });
        }

        private <T> T executePrevious(final WrappedOperation<T> wop) {
            List<VideoEffect> savedEffects = this.effects;
            try {
                this.effects = this.effects.subList(0, this.effects.size() - 1);
                Object t = VideoEffectPipelineImpl.this._vrContext.saveAndExecute(new WrappedOperation<T>(){

                    @Override
                    public T execute() {
                        return VideoEffectPipelineImpl.this._vrSupport.pushMatrixAndExecute(wop);
                    }
                });
                return t;
            }
            finally {
                this.effects = savedEffects;
            }
        }

        public Time getTime() {
            return VideoEffectPipelineImpl.this._vrContext.getTime();
        }

        public void setTime(Time time) {
            VideoEffectPipelineImpl.this._vrContext.setTime(time);
        }

        public <V> V value(PIAnimatableValue<V> avalue) {
            AnimatableValue av = (AnimatableValue)avalue;
            return av.value(VideoEffectPipelineImpl.this._vrContext);
        }

        public GL getGL() {
            return VideoEffectPipelineImpl.this._vrContext.getGL();
        }

        public GLU getGLU() {
            return VideoEffectPipelineImpl.this._vrContext.getGLU();
        }

        public RenderResolution getRenderResolution() {
            return VideoEffectPipelineImpl.this._vrContext.getRenderResolution();
        }

        public ColorMode getColorMode() {
            return VideoEffectPipelineImpl.this._vrContext.getColorMode();
        }

        public PIVideoBuffer createVideoBuffer(VideoBounds bounds) {
            return (PIVideoBuffer)VideoEffectPipelineImpl.this._vrSupport.createVideoBuffer(VideoEffectPipelineImpl.this._vrContext.getColorMode(), bounds);
        }
    }
}

