/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.RecentProjects;
import ch.kuramo.javie.app.actions.AVIOutputAction;
import ch.kuramo.javie.app.actions.NewCompositionAction;
import ch.kuramo.javie.app.actions.NewFileItemsAction;
import ch.kuramo.javie.app.actions.NewFolderAction;
import ch.kuramo.javie.app.actions.NewProjectAction;
import ch.kuramo.javie.app.actions.NewSolidColorItemAction;
import ch.kuramo.javie.app.actions.OpenProjectAction;
import ch.kuramo.javie.app.actions.QTMovieOutputAction;
import ch.kuramo.javie.app.actions.RedoAction;
import ch.kuramo.javie.app.actions.SaveAction;
import ch.kuramo.javie.app.actions.SaveAsAction;
import ch.kuramo.javie.app.actions.SaveCopyAction;
import ch.kuramo.javie.app.actions.ShowConsoleViewAction;
import ch.kuramo.javie.app.actions.ShowProjectViewAction;
import ch.kuramo.javie.app.actions.UndoAction;
import ch.kuramo.javie.app.player.GLCanvasFactory;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.EffectRegistry;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private NewProjectAction newProjectAction;
    private NewCompositionAction newCompositionAction;
    private NewSolidColorItemAction newSolidColorItemAction;
    private NewFolderAction newFolderAction;
    private OpenProjectAction openProjectAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private SaveCopyAction saveCopyAction;
    private NewFileItemsAction newFileItemsAction;
    private RetargetAction aviOutputAction;
    private RetargetAction qtMovieOutputAction;
    private RetargetAction sequenceOutputAction;
    private RetargetAction waveOutputAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private RetargetAction newCameraLayerAction;
    private RetargetAction newNullLayerAction;
    private RetargetAction newTextLayerAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ShowProjectViewAction showProjectViewAction;
    private ShowConsoleViewAction showConsoleViewAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private MenuManager recentProjectsMenu;
    @Inject
    private EffectRegistry effectRegistry;
    private final List<MenuManager> effectCategorySubMenus = Util.newList();
    private final List<Action> defaultCategoryEffectActions = Util.newList();

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        InjectorHolder.getInjector().injectMembers((Object)this);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.newProjectAction = new NewProjectAction(window);
        this.register((IAction)this.newProjectAction);
        this.newCompositionAction = new NewCompositionAction(window);
        this.register((IAction)this.newCompositionAction);
        this.newSolidColorItemAction = new NewSolidColorItemAction(window);
        this.register((IAction)this.newSolidColorItemAction);
        this.newFolderAction = new NewFolderAction(window);
        this.register((IAction)this.newFolderAction);
        this.openProjectAction = new OpenProjectAction(window);
        this.register((IAction)this.openProjectAction);
        this.saveAction = new SaveAction(window);
        this.register((IAction)this.saveAction);
        this.saveAsAction = new SaveAsAction(window);
        this.register((IAction)this.saveAsAction);
        this.saveCopyAction = new SaveCopyAction(window);
        this.register((IAction)this.saveCopyAction);
        this.newFileItemsAction = new NewFileItemsAction(window);
        this.register((IAction)this.newFileItemsAction);
        if (AVIOutputAction.isAvailable()) {
            this.aviOutputAction = new RetargetAction("ch.kuramo.javie.app.commands.AVIOutput", "AVI...");
            this.register((IAction)this.aviOutputAction);
            window.getPartService().addPartListener((IPartListener)this.aviOutputAction);
        }
        if (QTMovieOutputAction.isAvailable()) {
            this.qtMovieOutputAction = new RetargetAction("ch.kuramo.javie.app.commands.QTMovieOutput", "QuickTime \u30e0\u30fc\u30d3\u30fc...");
            this.register((IAction)this.qtMovieOutputAction);
            window.getPartService().addPartListener((IPartListener)this.qtMovieOutputAction);
        }
        this.sequenceOutputAction = new RetargetAction("ch.kuramo.javie.app.commands.sequenceOutput", "\u30a4\u30e1\u30fc\u30b8\u30b7\u30fc\u30b1\u30f3\u30b9...");
        this.register((IAction)this.sequenceOutputAction);
        window.getPartService().addPartListener((IPartListener)this.sequenceOutputAction);
        this.waveOutputAction = new RetargetAction("ch.kuramo.javie.app.commands.waveOutput", "Wave...");
        this.register((IAction)this.waveOutputAction);
        window.getPartService().addPartListener((IPartListener)this.waveOutputAction);
        if (!COCOA) {
            this.quitAction = ActionFactory.QUIT.create(window);
            this.register((IAction)this.quitAction);
        }
        this.undoAction = new UndoAction(window);
        this.register((IAction)this.undoAction);
        this.redoAction = new RedoAction(window);
        this.register((IAction)this.redoAction);
        this.newCameraLayerAction = new RetargetAction("ch.kuramo.javie.app.commands.newCameraLayer", "\u30ab\u30e1\u30e9");
        this.register((IAction)this.newCameraLayerAction);
        window.getPartService().addPartListener((IPartListener)this.newCameraLayerAction);
        this.newNullLayerAction = new RetargetAction("ch.kuramo.javie.app.commands.newNullLayer", "\u30cc\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8");
        this.register((IAction)this.newNullLayerAction);
        window.getPartService().addPartListener((IPartListener)this.newNullLayerAction);
        this.newTextLayerAction = new RetargetAction("ch.kuramo.javie.app.commands.newTextLayer", "\u30c6\u30ad\u30b9\u30c8");
        this.register((IAction)this.newTextLayerAction);
        window.getPartService().addPartListener((IPartListener)this.newTextLayerAction);
        GLCanvasFactory glCanavsFactory = GLCanvasFactory.getFactory();
        if (!glCanavsFactory.isPoolMode()) {
            this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
            this.register((IAction)this.newWindowAction);
        }
        this.showProjectViewAction = new ShowProjectViewAction(window);
        this.register((IAction)this.showProjectViewAction);
        this.showConsoleViewAction = new ShowConsoleViewAction(window);
        this.register((IAction)this.showConsoleViewAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
        this.recentProjectsMenu = RecentProjects.createMenuManager(window);
        this.makeEffectActions(window);
    }

    private void makeEffectActions(IWorkbenchWindow window) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("ch.kuramo.javie.api.effectCategory");
        if (point == null) {
            return;
        }
        Map subMenus = Util.newMap();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgElem = iConfigurationElementArray[n4];
                if ("effect-category".equals(cfgElem.getName())) {
                    String category = cfgElem.getAttribute("category");
                    String name = cfgElem.getAttribute("name");
                    MenuManager subMenu = new MenuManager(name);
                    subMenus.put(category, subMenu);
                    this.effectCategorySubMenus.add(subMenu);
                }
                ++n4;
            }
            ++n2;
        }
        for (EffectDescriptor ed : this.effectRegistry.getEffectDescriptors()) {
            RetargetAction action = new RetargetAction("EFFECT." + ed.getType(), ed.getLabel());
            window.getPartService().addPartListener((IPartListener)action);
            MenuManager subMenu = (MenuManager)subMenus.get(ed.getCategory());
            if (subMenu != null) {
                subMenu.add((IAction)action);
                continue;
            }
            this.defaultCategoryEffectActions.add((Action)action);
        }
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager("&File", "file");
        MenuManager fileNewMenu = new MenuManager("\u65b0\u898f");
        MenuManager inputMenu = new MenuManager("\u8aad\u307f\u8fbc\u307f");
        MenuManager outputMenu = new MenuManager("\u66f8\u304d\u51fa\u3057");
        MenuManager editMenu = new MenuManager("&Edit", "edit");
        MenuManager layerMenu = new MenuManager("&Layer");
        MenuManager layerNewMenu = new MenuManager("\u65b0\u898f");
        MenuManager effectMenu = new MenuManager("&Effect");
        MenuManager windowMenu = new MenuManager("&Window", "window");
        MenuManager helpMenu = new MenuManager("&Help", "help");
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)editMenu);
        menuBar.add((IContributionItem)layerMenu);
        menuBar.add((IContributionItem)effectMenu);
        menuBar.add((IContributionItem)windowMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)helpMenu);
        fileMenu.add((IContributionItem)fileNewMenu);
        fileMenu.add((IAction)this.openProjectAction);
        fileMenu.add((IContributionItem)this.recentProjectsMenu);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.saveAction);
        fileMenu.add((IAction)this.saveAsAction);
        fileMenu.add((IAction)this.saveCopyAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)inputMenu);
        fileMenu.add((IContributionItem)outputMenu);
        if (this.quitAction != null) {
            fileMenu.add((IContributionItem)new Separator());
            fileMenu.add((IAction)this.quitAction);
        }
        fileNewMenu.add((IAction)this.newProjectAction);
        fileNewMenu.add((IAction)this.newCompositionAction);
        fileNewMenu.add((IAction)this.newSolidColorItemAction);
        fileNewMenu.add((IAction)this.newFolderAction);
        inputMenu.add((IAction)this.newFileItemsAction);
        if (this.aviOutputAction != null) {
            outputMenu.add((IAction)this.aviOutputAction);
        }
        if (this.qtMovieOutputAction != null) {
            outputMenu.add((IAction)this.qtMovieOutputAction);
        }
        outputMenu.add((IAction)this.sequenceOutputAction);
        outputMenu.add((IAction)this.waveOutputAction);
        editMenu.add((IAction)this.undoAction);
        editMenu.add((IAction)this.redoAction);
        layerMenu.add((IContributionItem)layerNewMenu);
        layerNewMenu.add((IAction)this.newCameraLayerAction);
        layerNewMenu.add((IAction)this.newNullLayerAction);
        layerNewMenu.add((IAction)this.newTextLayerAction);
        for (MenuManager effectCategoryMenu : this.effectCategorySubMenus) {
            effectMenu.add((IContributionItem)effectCategoryMenu);
        }
        for (Action effectAction : this.defaultCategoryEffectActions) {
            effectMenu.add((IAction)effectAction);
        }
        if (this.newWindowAction != null) {
            windowMenu.add((IAction)this.newWindowAction);
            windowMenu.add((IContributionItem)new Separator());
        }
        windowMenu.add((IAction)this.showProjectViewAction);
        windowMenu.add((IAction)this.showConsoleViewAction);
        helpMenu.add((IAction)this.aboutAction);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolBar = new ToolBarManager(0x820000);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBar, "main"));
        GLCanvasFactory glCanavsFactory = GLCanvasFactory.getFactory();
        if (glCanavsFactory.isPoolMode()) {
            toolBar.add((IContributionItem)glCanavsFactory.createControlContribution());
        }
    }
}

