/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.ApplicationActionBarAdvisor;
import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.actions.NewProjectAction;
import ch.kuramo.javie.app.project.ProjectEvent;
import ch.kuramo.javie.app.project.ProjectEventHub;
import ch.kuramo.javie.app.project.ProjectListener;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.MediaItem;
import java.io.File;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor
implements ProjectListener {
    private static final String DONE_SAVE_CONFIRMATION = "DONE_SAVE_CONFIRMATION";
    private boolean _maximizeShell = true;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public IStatus restoreState(IMemento memento) {
        this._maximizeShell = false;
        return Status.OK_STATUS;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(800, 600));
        configurer.setShowMenuBar(true);
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(false);
        configurer.setTitle("Javie");
    }

    public void postWindowCreate() {
        ProjectEventHub.getHub().addProjectListener(this);
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        if (this._maximizeShell) {
            shell.setMaximized(true);
        }
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                NewProjectAction.newProject(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow());
            }
        });
    }

    static boolean saveConfirmationRequired(IWorkbenchWindow window) {
        Object data = window.getShell().getData(DONE_SAVE_CONFIRMATION);
        return !Boolean.TRUE.equals(data);
    }

    public boolean preWindowShellClose() {
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
        if (pm != null) {
            switch (SaveUtil.saveIfDirty(pm)) {
                case NOT_DIRTY: 
                case SAVED: 
                case UNSAVED: {
                    window.getShell().setData(DONE_SAVE_CONFIRMATION, (Object)Boolean.TRUE);
                    return true;
                }
            }
        }
        return false;
    }

    public void postWindowClose() {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getWindowConfigurer().getWindow());
        if (pm != null) {
            pm.dispose();
        }
        ProjectEventHub.getHub().removeProjectListener(this);
    }

    private void updateWindowTitle(ProjectManager pm) {
        String title;
        File file = pm.getFile();
        boolean dirty = pm.isDirty();
        String string = title = file != null ? file.getName() : "\u540d\u79f0\u672a\u8a2d\u5b9a\u30d7\u30ed\u30b8\u30a7\u30af\u30c8.jvp";
        if (dirty) {
            title = String.valueOf(title) + " *";
        }
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        shell.setText(title);
        shell.setModified(dirty);
    }

    private void resetWindowTitle() {
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        shell.setText("Javie");
        shell.setModified(false);
    }

    private void hideViews(Set<Item> items) {
        IWorkbenchPage page = this.getWindowConfigurer().getWindow().getActivePage();
        for (Item item : items) {
            IViewReference viewRef;
            if (item instanceof MediaItem && (viewRef = page.findViewReference("ch.kuramo.javie.app.views.mediaPlayerView", item.getId())) != null) {
                page.hideView(viewRef);
            }
            if (!(item instanceof CompositionItem) || (viewRef = page.findViewReference("ch.kuramo.javie.app.views.layerCompositionView", item.getId())) == null) continue;
            page.hideView(viewRef);
        }
    }

    @Override
    public void handleProjectEvent(ProjectEvent event) {
        ProjectManager pm = event.getProjectManager();
        if (pm.getWorkbenchWindow() != this.getWindowConfigurer().getWindow()) {
            return;
        }
        switch (event.type) {
            case PROJECT_INITIALIZE: 
            case DIRTY_CHANGE: 
            case FILE_CHANGE: {
                this.updateWindowTitle(pm);
                break;
            }
            case PROJECT_DISPOSE: {
                this.resetWindowTitle();
                break;
            }
            case ITEMS_REMOVE: {
                this.hideViews(ProjectEvent.getItems(event));
            }
        }
    }
}

