/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

public class WaveOutputAction
extends Action {
    private static File defaultFolder;
    private final LayerCompositionView view;
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;
    @Inject
    private AudioRenderContext arContext;
    @Inject
    private IArrayPools _arrayPools;

    public WaveOutputAction(LayerCompositionView view) {
        super("Wave...");
        InjectorHolder.getInjector().injectMembers((Object)this);
        this.view = view;
        this.setId("ch.kuramo.javie.app.commands.waveOutput");
        this.setActionDefinitionId("ch.kuramo.javie.app.commands.waveOutput");
    }

    public void run() {
        CompositionItem compItem;
        File file;
        File file2;
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getWindow());
        if (pm == null) {
            return;
        }
        if (defaultFolder == null && (file2 = pm.getFile()) != null) {
            defaultFolder = file2.getParentFile();
        }
        if ((file = this.showSaveDialog(defaultFolder, String.valueOf((compItem = this.view.getCompositionItem()).getName()) + ".wav")) != null) {
            defaultFolder = file.getParentFile();
            this.doOutput(pm.getProject(), compItem.getId(), file);
        }
    }

    private IWorkbenchWindow getWindow() {
        return this.view.getSite().getWorkbenchWindow();
    }

    private File showSaveDialog(File folder, String name) {
        String[] filterNames = new String[]{"Wave Files", "All Files (*)"};
        String[] filterExtensions = new String[]{"*.wav", "*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterNames = new String[]{"Wave Files", "All Files (*.*)"};
            filterExtensions = new String[]{"*.wav", "*.*"};
        }
        FileDialog dialog = new FileDialog(this.getWindow().getShell(), 0x10002000);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(folder != null ? folder.getAbsolutePath() : null);
        dialog.setFileName(name);
        dialog.setOverwrite(true);
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }

    /*
     * Unable to fully structure code
     */
    private void doOutput(Project project, String compItemId, File file) {
        block11: {
            block10: {
                block12: {
                    copy = null;
                    try {
                        try {
                            copy = (Project)this.decoder.decodeElement((CharSequence)this.encoder.encodeElement((Object)project), Project.class);
                            copy.afterDecode();
                            dialog = new ProgressMonitorDialog(this.getWindow().getShell());
                            dialog.create();
                            dialog.getShell().setText("\u66f8\u304d\u51fa\u3057");
                            dialog.run(true, true, (IRunnableWithProgress)new WaveOutput((CompositionItem)copy.getItem(compItemId), file));
                            break block10;
                        }
                        catch (ProjectDecodeException e) {
                            throw new JavieRuntimeException((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new JavieRuntimeException((Throwable)e);
                        }
                        catch (InterruptedException v0) {
                            file.delete();
                            if (copy == null) break block11;
                            ** for (i : copy.getItems())
                        }
                    }
                    catch (Throwable var6_14) {
                        if (copy == null) break block12;
                        ** for (i : copy.getItems())
                    }
lbl-1000:
                    // 1 sources

                    {
                        i.dispose();
                        continue;
lbl22:
                        // 1 sources

                        break block11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        i.dispose();
                        continue;
                    }
                }
                throw var6_14;
            }
            if (copy != null) {
                for (Item i : copy.getItems()) {
                    i.dispose();
                }
            }
        }
    }

    private class WaveOutput
    implements IRunnableWithProgress {
        private final CompositionItem compItem;
        private final File file;

        private WaveOutput(CompositionItem compItem, File file) {
            this.compItem = compItem;
            this.file = file;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            WaveOutputThread thread;
            Composition comp = this.compItem.getComposition();
            Time duration = comp.getDuration();
            Time videoFrameDuration = comp.getFrameDuration();
            long videoFrameCount = duration.toFrameNumber(videoFrameDuration);
            monitor.beginTask(String.format("\u66f8\u304d\u51fa\u3057: %s", this.compItem.getName()), (int)videoFrameCount);
            AudioMode audioMode = AudioMode.STEREO_48KHZ_INT16;
            int chunkFrames = audioMode.sampleRate / 10;
            long totalFrames = duration.toFrameNumber(audioMode.sampleDuration);
            PipedOutputStream pout = new PipedOutputStream();
            try {
                thread = new WaveOutputThread(pout, audioMode, totalFrames, this.file);
                thread.start();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            WaveOutputAction.this.arContext.activate();
            try {
                comp.prepareExpression(WaveOutputAction.this.arContext.createInitialExpressionScope(comp));
                long videoFrameNumber = 0L;
                long i = 0L;
                while (i < totalFrames) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    if (thread.exception != null) {
                        throw new InvocationTargetException(thread.exception);
                    }
                    monitor.subTask(String.format("\u30d5\u30ec\u30fc\u30e0: %d/%d", videoFrameNumber, videoFrameCount));
                    Time time = Time.fromFrameNumber((long)i, (Time)audioMode.sampleDuration);
                    WaveOutputAction.this.arContext.reset();
                    WaveOutputAction.this.arContext.setAudioMode(audioMode);
                    WaveOutputAction.this.arContext.setTime(time);
                    WaveOutputAction.this.arContext.setFrameCount((int)Math.min((long)chunkFrames, totalFrames - i));
                    WaveOutputAction.this.arContext.setEvaluationResolution(audioMode.sampleRate / 100);
                    AudioBuffer ab = comp.renderAudioChunk();
                    try {
                        try {
                            if (ab != null) {
                                this.write(ab, pout);
                                i += (long)ab.getFrameCount();
                            } else {
                                this.writeZero(audioMode, WaveOutputAction.this.arContext.getFrameCount(), pout);
                                i += (long)WaveOutputAction.this.arContext.getFrameCount();
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        if (ab != null) {
                            ab.dispose();
                        }
                    }
                    long nextVideoFrameNumber = time.toFrameNumber(videoFrameDuration);
                    if (nextVideoFrameNumber == videoFrameNumber) continue;
                    monitor.worked((int)(nextVideoFrameNumber - videoFrameNumber));
                    videoFrameNumber = nextVideoFrameNumber;
                }
            }
            finally {
                WaveOutputAction.this.arContext.deactivate();
                try {
                    pout.close();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
            monitor.done();
        }

        private void write(AudioBuffer ab, OutputStream out) throws IOException {
            AudioMode audioMode = ab.getAudioMode();
            int dataLen = ab.getDataLength();
            int dataLenInBytes = ab.getDataLengthInBytes();
            IArray pa = WaveOutputAction.this._arrayPools.getByteArray(dataLenInBytes);
            byte[] outBuf = (byte[])pa.getArray();
            switch (audioMode.dataType) {
                case SHORT: {
                    ByteBuffer.wrap(outBuf, 0, dataLenInBytes).order(ByteOrder.nativeOrder()).asShortBuffer().put((short[])ab.getData(), 0, dataLen);
                    break;
                }
                case INT: {
                    int[] data = (int[])ab.getData();
                    int i = 0;
                    while (i < dataLen) {
                        outBuf[i * 2] = (byte)(data[i] >>> 16 & 0xFF);
                        outBuf[i * 2 + 1] = (byte)(data[i] >>> 24 & 0xFF);
                        ++i;
                    }
                    break;
                }
                case FLOAT: {
                    float[] data = (float[])ab.getData();
                    int i = 0;
                    while (i < dataLen) {
                        short shortVal = (short)(Math.min(Math.max((double)data[i], -1.0), 1.0) * 32767.0);
                        outBuf[i * 2] = (byte)(shortVal & 0xFF);
                        outBuf[i * 2 + 1] = (byte)(shortVal >>> 8 & 0xFF);
                        ++i;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
                }
            }
            out.write(outBuf, 0, dataLenInBytes);
            pa.release();
        }

        private void writeZero(AudioMode audioMode, int frameCount, OutputStream out) throws IOException {
            IArray pa = WaveOutputAction.this._arrayPools.getByteArray(audioMode.frameSize * frameCount);
            pa.clear();
            out.write((byte[])pa.getArray(), 0, pa.getLength());
            pa.release();
        }
    }

    private class WaveOutputThread
    extends Thread {
        final PipedInputStream inputStream;
        final AudioMode audioMode;
        final long totalFrames;
        final File file;
        Exception exception;

        WaveOutputThread(PipedOutputStream src, AudioMode audioMode, long totalFrames, File file) throws IOException {
            this.inputStream = new PipedInputStream(src);
            this.audioMode = audioMode;
            this.totalFrames = totalFrames;
            this.file = file;
        }

        public void run() {
            AudioFormat format = new AudioFormat(this.audioMode.sampleRate, this.audioMode.sampleSize * 8, this.audioMode.channels, true, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
            AudioInputStream ais = new AudioInputStream(this.inputStream, format, (long)this.audioMode.frameSize * this.totalFrames);
            try {
                try {
                    AudioSystem.write(ais, AudioFileFormat.Type.WAVE, this.file);
                }
                catch (IOException e) {
                    this.exception = e;
                    try {
                        ais.close();
                    }
                    catch (IOException e2) {
                        this.exception = e2;
                    }
                }
            }
            finally {
                try {
                    ais.close();
                }
                catch (IOException e) {
                    this.exception = e;
                }
            }
        }
    }
}

