/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableColor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableColorElementDelegate
extends AnimatableValueElementDelegate<Color> {
    private org.eclipse.swt.graphics.Color swtColor;

    public AnimatableColorElementDelegate(AnimatableValueElement element, String name, AnimatableColor avalue) {
        super(element, name, avalue);
        element.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AnimatableColorElementDelegate.this.swtColor != null) {
                    AnimatableColorElementDelegate.this.swtColor.dispose();
                    AnimatableColorElementDelegate.this.swtColor = null;
                }
            }
        });
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        this.drawColor(gc, x, y, height);
    }

    @Override
    protected boolean canDragGestureEdit() {
        return false;
    }

    @Override
    protected Color dragGesture(double dx, double dy) {
        throw new UnsupportedOperationException("drag gesture edit is not supported");
    }

    @Override
    public void mouseDown(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                Rectangle r;
                if (event.button != 1 || !(r = (Rectangle)this.valueArea.get(0)).contains(event.x, event.y)) break;
                this.doColorDialog();
                break;
            }
            default: {
                super.mouseDown(event, columnIndex);
            }
        }
    }

    private int drawColor(GC gc, int x, int y, int height) {
        Rectangle rect = new Rectangle(x + 1, y + 1, height - 2, height - 2);
        RGB rgb = this.getRGB();
        if (this.swtColor == null || !this.swtColor.getRGB().equals((Object)rgb)) {
            if (this.swtColor != null) {
                this.swtColor.dispose();
            }
            this.swtColor = new org.eclipse.swt.graphics.Color(gc.getDevice(), rgb);
        }
        gc.setBackground(this.swtColor);
        gc.fillRectangle(rect);
        gc.setForeground(gc.getDevice().getSystemColor(2));
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        this.valueArea.add(rect);
        return rect.x + rect.width;
    }

    private void doColorDialog() {
        ColorDialog dialog = new ColorDialog(this.element.viewer.getTree().getShell());
        dialog.setRGB(this.getRGB());
        RGB rgb = dialog.open();
        if (rgb != null) {
            this.modifyValue(new Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0));
        }
    }

    private RGB getRGB() {
        return new RGB((int)Math.round(((Color)this.value).r * 255.0), (int)Math.round(((Color)this.value).g * 255.0), (int)Math.round(((Color)this.value).b * 255.0));
    }
}

