/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableInteger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableIntegerElementDelegate
extends AnimatableValueElementDelegate<Integer> {
    protected final int increment;
    protected final String unit;
    protected IntegerCellEditor editor;

    public AnimatableIntegerElementDelegate(AnimatableValueElement element, String name, AnimatableInteger avalue) {
        this(element, name, avalue, 1, null);
    }

    public AnimatableIntegerElementDelegate(AnimatableValueElement element, String name, AnimatableInteger avalue, String unit) {
        this(element, name, avalue, 1, unit);
    }

    public AnimatableIntegerElementDelegate(AnimatableValueElement element, String name, AnimatableInteger avalue, int increment, String unit) {
        super(element, name, avalue);
        this.increment = increment;
        this.unit = unit;
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        if (this.editor == null) {
            this.drawValue(gc, x, y, height, focused, (Integer)this.value, this.unit);
        }
    }

    @Override
    protected boolean canDragGestureEdit() {
        return true;
    }

    @Override
    protected Integer dragGesture(double dx, double dy) {
        return (Integer)this.originalValue + (int)((double)this.increment * dx);
    }

    @Override
    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return this.canInlineEdit;
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new IntegerCellEditor((Composite)this.element.viewer.getTree(), 2052);
            }
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            return ((Integer)this.value).toString();
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            try {
                this.modifyValue(Integer.valueOf((String)value));
            }
            catch (NumberFormatException numberFormatException) {
                this.element.viewer.getTree().getDisplay().beep();
            }
        }
    }

    private class IntegerCellEditor
    extends TextCellEditor {
        private boolean activated;

        private IntegerCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Control createControl(final Composite parent) {
            final Composite composite = new Composite(parent, 0x80000 | (COCOA ? 262144 : 0));
            composite.setFont(parent.getFont());
            composite.setBackground(parent.getBackground());
            composite.setLayout((Layout)new FormLayout());
            super.createControl(composite);
            this.text.setBackground(this.text.getDisplay().getSystemColor(1));
            int right = 0;
            if (AnimatableIntegerElementDelegate.this.unit != null) {
                GC gc = new GC((Drawable)composite);
                right = gc.textExtent((String)AnimatableIntegerElementDelegate.this.unit, (int)1).x + 10;
                gc.dispose();
            }
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            data.left = new FormAttachment(0, WIN32 ? 3 : 0);
            data.right = new FormAttachment(100, -right);
            this.text.setLayoutData((Object)data);
            composite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    parent.forceFocus();
                }
            });
            composite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Rectangle bounds = IntegerCellEditor.this.text.getBounds();
                    int height = composite.getBounds().height;
                    AnimatableIntegerElementDelegate.this.setValueForeground(e.gc, false);
                    AnimatableIntegerElementDelegate.this.drawString(e.gc, bounds.width + 5, 0, height, ((IntegerCellEditor)IntegerCellEditor.this).AnimatableIntegerElementDelegate.this.unit);
                }
            });
            return composite;
        }

        public void activate() {
            super.activate();
            this.activated = true;
        }

        public void deactivate() {
            super.deactivate();
            if (this.activated) {
                AnimatableIntegerElementDelegate.this.editor = null;
                this.dispose();
            }
        }
    }
}

