/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractItem;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="composition")
public class CompositionItemImpl
extends AbstractItem
implements CompositionItem {
    private String _compositionId;
    private Composition _composition;
    private final CompositionInput _input = new CompositionInput();
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderContext _arContext;

    public void initialize(Composition composition) {
        super.initialize();
        this._compositionId = composition.getId();
        this._composition = composition;
    }

    public void dispose() {
        this._composition = null;
    }

    public String getCompositionId() {
        return this._compositionId;
    }

    public void setCompositionId(String compositionId) {
        this._compositionId = compositionId;
    }

    @JSONHint(ignore=true)
    public Composition getComposition() {
        return this._composition;
    }

    public void afterDecode(Project p) throws ProjectDecodeException {
        super.afterDecode(p);
        this._composition = p.getComposition(this._compositionId);
        if (this._composition == null) {
            throw new ProjectDecodeException("no such Composition found: id=" + this._compositionId);
        }
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._input;
    }

    @JSONHint(ignore=true)
    public String getKind() {
        return "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3";
    }

    private class CompositionInput
    implements MediaInput {
        private CompositionInput() {
        }

        public void dispose() {
        }

        public boolean isVideoAvailable() {
            return true;
        }

        public boolean isAudioAvailable() {
            return true;
        }

        public Time getDuration() {
            return CompositionItemImpl.this._composition.getDuration();
        }

        public Time getVideoFrameDuration() {
            return CompositionItemImpl.this._composition.getFrameDuration();
        }

        public VideoBounds getVideoFrameBounds() {
            Size2i size = CompositionItemImpl.this._composition.getSize();
            return new VideoBounds(size.width, size.height);
        }

        public VideoBuffer getVideoFrameImage(final Time mediaTime) {
            VideoBuffer vb = CompositionItemImpl.this._vrContext.saveAndExecute(new WrappedOperation<VideoBuffer>(){

                @Override
                public VideoBuffer execute() {
                    CompositionItemImpl.this._vrContext.setTime(mediaTime);
                    return CompositionItemImpl.this._composition.renderVideoFrame();
                }
            });
            CompositionItemImpl.this._vrSupport.premultiply(vb);
            return vb;
        }

        public AudioBuffer getAudioChunk(final Time mediaTime) {
            return CompositionItemImpl.this._arContext.saveAndExecute(new WrappedOperation<AudioBuffer>(){

                @Override
                public AudioBuffer execute() {
                    CompositionItemImpl.this._arContext.setTime(mediaTime);
                    return CompositionItemImpl.this._composition.renderAudioChunk();
                }
            });
        }
    }
}

