/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableHorizontalAlignment;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.HorizontalAlignment;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.AbstractMediaLayer;
import ch.kuramo.javie.core.services.Font;
import ch.kuramo.javie.core.services.FontList;
import ch.kuramo.javie.core.services.FontManager;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.util.regex.Pattern;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="textLayer")
public class TextLayerImpl
extends AbstractMediaLayer
implements TextLayer {
    private final TextInput _input = new TextInput();
    private boolean _ctcr;
    private AnimatableString _sourceText = new AnimatableString("\u30c6\u30ad\u30b9\u30c8");
    private AnimatableString _font = new AnimatableString("");
    private AnimatableInteger _fontSize = new AnimatableInteger((Integer)36, 1, Integer.MAX_VALUE);
    private AnimatableColor _fillColor = new AnimatableColor(Color.WHITE);
    private AnimatableHorizontalAlignment _horizontalAlignment = new AnimatableHorizontalAlignment(HorizontalAlignment.LEFT);
    private AnimatableDouble _leading = new AnimatableDouble(-1.0);
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private FontList _fontList;
    @Inject
    private FontManager _fontManager;
    private static final Pattern LF = Pattern.compile("\n");

    protected void initialize(boolean videoAvailable, boolean audioAvailable) {
        throw new UnsupportedOperationException("Use initialize() method instead.");
    }

    public void initialize() {
        super.initialize(true, false);
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._input;
    }

    public boolean isCTCR() {
        return this._ctcr;
    }

    public void setCTCR(boolean ctcr) {
        this._ctcr = ctcr;
    }

    public AnimatableString getSourceText() {
        return this._sourceText;
    }

    public void setSourceText(AnimatableString sourceText) {
        sourceText.copyConfigurationFrom(this._sourceText);
        this._sourceText = sourceText;
    }

    public AnimatableString getFont() {
        return this._font;
    }

    public void setFont(AnimatableString font) {
        font.copyConfigurationFrom(this._font);
        this._font = font;
    }

    public AnimatableInteger getFontSize() {
        return this._fontSize;
    }

    public void setFontSize(AnimatableInteger fontSize) {
        fontSize.copyConfigurationFrom(this._fontSize);
        this._fontSize = fontSize;
    }

    public AnimatableColor getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(AnimatableColor fillColor) {
        fillColor.copyConfigurationFrom(this._fillColor);
        this._fillColor = fillColor;
    }

    public AnimatableHorizontalAlignment getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public void setHorizontalAlignment(AnimatableHorizontalAlignment horizontalAlignment) {
        horizontalAlignment.copyConfigurationFrom(this._horizontalAlignment);
        this._horizontalAlignment = horizontalAlignment;
    }

    public AnimatableDouble getLeading() {
        return this._leading;
    }

    public void setLeading(AnimatableDouble leading) {
        leading.copyConfigurationFrom(this._leading);
        this._leading = leading;
    }

    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this._sourceText);
        scope.assignTo(this._font);
        scope.assignTo(this._fontSize);
        scope.assignTo(this._fillColor);
        scope.assignTo(this._horizontalAlignment);
        scope.assignTo(this._leading);
    }

    public Object createExpressionElement(RenderContext renderContext) {
        return new TextLayerExpressionElement(renderContext);
    }

    private class TextInput
    implements VectorMediaInput {
        private TextInput() {
        }

        public void dispose() {
        }

        public boolean isVideoAvailable() {
            return true;
        }

        public boolean isAudioAvailable() {
            return false;
        }

        public Time getDuration() {
            return null;
        }

        public Time getVideoFrameDuration() {
            return null;
        }

        public VideoBounds getVideoFrameBounds() {
            int width;
            double x;
            if (!TextLayerImpl.this._vrContext.isActive()) {
                return null;
            }
            String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._vrContext);
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._vrContext);
            int fontSize = (Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._vrContext);
            FTGLfont font = this.getFont(psName, fontSize);
            if (sourceText.length() == 0 || font == null) {
                return new VideoBounds(1, 1);
            }
            HorizontalAlignment halign = (HorizontalAlignment)((Object)TextLayerImpl.this._horizontalAlignment.value(TextLayerImpl.this._vrContext));
            double leading = (Double)TextLayerImpl.this._leading.value(TextLayerImpl.this._vrContext);
            if (leading < 0.0) {
                leading = (double)fontSize * 1.2;
            }
            double upper = 0.0;
            double lower = Double.MAX_VALUE;
            double advanced = 0.0;
            String[] texts = LF.split(sourceText);
            float[] box = new float[6];
            int i = 0;
            while (i < texts.length) {
                FTGL.ftglGetFontBBox(font, texts[i], -1, box);
                upper = Math.max(upper, (double)box[4]);
                lower = Math.min(lower, (double)box[1]);
                advanced = Math.max(advanced, (double)FTGL.ftglGetFontAdvance(font, texts[i]));
                ++i;
            }
            upper = Math.ceil(upper) + 1.0;
            lower = Math.floor(lower) - 1.0;
            switch (halign) {
                default: {
                    x = 0.0;
                    width = (int)Math.ceil(advanced);
                    break;
                }
                case CENTER: {
                    x = -Math.ceil(advanced / 2.0);
                    width = (int)(-x) * 2;
                    break;
                }
                case RIGHT: {
                    x = -Math.ceil(advanced);
                    width = (int)(-x) + 1;
                }
            }
            return new VideoBounds(x, -upper, width, (int)(upper + Math.ceil(leading * (double)(texts.length - 1)) - lower));
        }

        public VideoBuffer getVideoFrameImage(Time mediaTime) {
            RenderResolution resolution = TextLayerImpl.this._vrContext.getRenderResolution();
            VideoBounds bounds = resolution.scale(this.getVideoFrameBounds());
            VideoBuffer vb = TextLayerImpl.this._vrSupport.createVideoBuffer(TextLayerImpl.this._vrContext.getColorMode(), bounds);
            vb.allocateAsTexture();
            vb.clear();
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._vrContext);
            int fontSize = (Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._vrContext);
            FTGLfont font = this.getFont(psName, fontSize);
            if (font != null) {
                String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._vrContext);
                Color fillColor = (Color)TextLayerImpl.this._fillColor.value(TextLayerImpl.this._vrContext);
                HorizontalAlignment halign = (HorizontalAlignment)((Object)TextLayerImpl.this._horizontalAlignment.value(TextLayerImpl.this._vrContext));
                double leading = (Double)TextLayerImpl.this._leading.value(TextLayerImpl.this._vrContext);
                String[] texts = LF.split(sourceText);
                if (leading < 0.0) {
                    leading = (double)fontSize * 1.2;
                }
                leading = resolution.scale(leading);
                double[][] offsets = this.calcTextOffsets(font, texts, halign, leading, resolution);
                TextLayerImpl.this._vrSupport.renderText(font, fillColor, texts, offsets, vb);
            }
            return vb;
        }

        public void rasterize(VideoBuffer resultBuffer, DepthBuffer depthBuffer, double[] mvMatrix, double[] prjMatrix) {
            int fontSize;
            RenderResolution resolution = TextLayerImpl.this._vrContext.getRenderResolution();
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._vrContext);
            FTGLfont font = this.getFont(psName, fontSize = ((Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._vrContext)).intValue());
            if (font != null) {
                String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._vrContext);
                Color fillColor = (Color)TextLayerImpl.this._fillColor.value(TextLayerImpl.this._vrContext);
                HorizontalAlignment halign = (HorizontalAlignment)((Object)TextLayerImpl.this._horizontalAlignment.value(TextLayerImpl.this._vrContext));
                double leading = (Double)TextLayerImpl.this._leading.value(TextLayerImpl.this._vrContext);
                String[] texts = LF.split(sourceText);
                if (leading < 0.0) {
                    leading = (double)fontSize * 1.2;
                }
                leading = resolution.scale(leading);
                double[][] offsets = this.calcTextOffsets(font, texts, halign, leading, resolution);
                TextLayerImpl.this._vrSupport.renderText(font, fillColor, texts, offsets, resultBuffer, depthBuffer, mvMatrix, prjMatrix);
            }
        }

        private FTGLfont getFont(String psName, int fontSize) {
            Font font = TextLayerImpl.this._fontList.get(psName);
            if (font == null && (font = TextLayerImpl.this._fontList.defaultFont()) == null) {
                return null;
            }
            String fontPath = font.fontFile.getAbsolutePath();
            int faceIndex = font.faceIndex;
            if (TextLayerImpl.this._ctcr) {
                return TextLayerImpl.this._fontManager.getPolygonFont(fontPath, faceIndex, fontSize);
            }
            return TextLayerImpl.this._fontManager.getBufferFont(fontPath, faceIndex, fontSize);
        }

        private double[][] calcTextOffsets(FTGLfont font, String[] texts, HorizontalAlignment halign, double leading, RenderResolution resolution) {
            double[][] offsets = new double[texts.length][2];
            switch (halign) {
                default: {
                    int i = 0;
                    while (i < texts.length) {
                        offsets[i] = new double[]{0.0, leading * (double)i};
                        ++i;
                    }
                    break;
                }
                case CENTER: {
                    int i = 0;
                    while (i < texts.length) {
                        double advance = resolution.scale((double)FTGL.ftglGetFontAdvance(font, texts[i]));
                        offsets[i] = new double[]{-advance / 2.0, leading * (double)i};
                        ++i;
                    }
                    break;
                }
                case RIGHT: {
                    int i = 0;
                    while (i < texts.length) {
                        double advance = resolution.scale((double)FTGL.ftglGetFontAdvance(font, texts[i]));
                        offsets[i] = new double[]{-advance, leading * (double)i};
                        ++i;
                    }
                    break block0;
                }
            }
            return offsets;
        }

        public AudioBuffer getAudioChunk(Time mediaTime) {
            throw new UnsupportedOperationException("audio is not available");
        }
    }

    public class TextLayerExpressionElement
    extends AbstractMediaLayer.MediaLayerExpressionElement {
        public TextLayerExpressionElement(RenderContext renderContext) {
            super(renderContext);
        }

        public Object getSourceText() {
            return this.elem(TextLayerImpl.this._sourceText);
        }

        public Object getFont() {
            return this.elem(TextLayerImpl.this._font);
        }

        public Object getFontSize() {
            return this.elem(TextLayerImpl.this._fontSize);
        }

        public Object getFillColor() {
            return this.elem(TextLayerImpl.this._fillColor);
        }

        public Object getHorizontalAlignment() {
            return this.elem(TextLayerImpl.this._horizontalAlignment);
        }

        public Object getLeading() {
            return this.elem(TextLayerImpl.this._leading);
        }
    }
}

