/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.services.FontManager;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontManagerImpl
implements FontManager {
    private static final Logger logger = LoggerFactory.getLogger(FontManagerImpl.class);
    private static final int MAX_FONTS = 8;
    private final Map<String, FTGLfont> _fontCache = new LinkedHashMap<String, FTGLfont>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, FTGLfont> eldest) {
            if (this.size() > 8) {
                String key = eldest.getKey();
                FTGL.ftglDestroyFont(eldest.getValue());
                this.remove(key);
                logger.info("font removed from cache: " + key);
            }
            return false;
        }
    };

    void dispose() {
        for (Map.Entry<String, FTGLfont> e : this._fontCache.entrySet()) {
            FTGL.ftglDestroyFont(e.getValue());
        }
        this._fontCache.clear();
    }

    public FTGLfont getPolygonFont(String filename, int faceIndex, int size) {
        return this.getFont(FontType.Polygon, filename, faceIndex, size);
    }

    public FTGLfont getOutlineFont(String filename, int faceIndex, int size) {
        return this.getFont(FontType.Outline, filename, faceIndex, size);
    }

    public FTGLfont getExtrudeFont(String filename, int faceIndex, int size) {
        return this.getFont(FontType.Extrude, filename, faceIndex, size);
    }

    public FTGLfont getTextureFont(String filename, int faceIndex, int size) {
        return this.getFont(FontType.Texture, filename, faceIndex, size);
    }

    public FTGLfont getBufferFont(String filename, int faceIndex, int size) {
        return this.getFont(FontType.Buffer, filename, faceIndex, size);
    }

    private FTGLfont getFont(FontType type, String filename, int faceIndex, int size) {
        try {
            filename = new File(filename).getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.warn("cannot get canonical path for font: " + filename);
        }
        filename = String.format("%d,%s", faceIndex, filename);
        String key = String.format("%s,%s,%d", type.name(), filename, size);
        FTGLfont font = this._fontCache.get(key);
        if (font != null) {
            return font;
        }
        switch (type) {
            case Polygon: {
                font = FTGL.ftglCreatePolygonFont(filename);
                break;
            }
            case Outline: {
                font = FTGL.ftglCreateOutlineFont(filename);
                break;
            }
            case Extrude: {
                font = FTGL.ftglCreateExtrudeFont(filename);
                break;
            }
            case Texture: {
                font = FTGL.ftglCreateTextureFont(filename);
                break;
            }
            case Buffer: {
                font = FTGL.ftglCreateBufferFont(filename);
                break;
            }
            default: {
                throw new JavieRuntimeException("unsupported font type");
            }
        }
        int error = FTGL.ftglGetFontError(font);
        if (error != 0) {
            FTGL.ftglDestroyFont(font);
            throw new JavieRuntimeException(String.format("ftglCreate%sFont failed: error=%d", type.name(), error));
        }
        FTGL.ftglSetFontCharMap(font, 1970170211);
        FTGL.ftglSetFontFaceSize(font, size, 72);
        this._fontCache.put(key, font);
        return font;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FontType {
        Polygon,
        Outline,
        Extrude,
        Texture,
        Buffer;

    }
}

