/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.services.GLGlobal;
import java.util.LinkedList;
import java.util.Queue;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;

public class GLGlobalImpl
implements GLGlobal {
    private final Object _lock = new Object();
    private final GLPbuffer _pbuffer;
    private final GLContext _sharedContext;
    private Queue<GLContext> _pool;
    private GLCapabilities _canvasCapabilities;

    public GLGlobalImpl() {
        GLCapabilities glcap = new GLCapabilities();
        glcap.setHardwareAccelerated(true);
        glcap.setDoubleBuffered(false);
        this._pbuffer = GLDrawableFactory.getFactory().createGLPbuffer(glcap, null, 1, 1, null);
        this._sharedContext = this._pbuffer.getContext();
        this._canvasCapabilities = glcap;
    }

    public Object getLockObject() {
        return this._lock;
    }

    public GLContext getSharedContext() {
        return this._sharedContext;
    }

    public void enterPoolMode(final int poolSize) {
        if (this._pool != null) {
            throw new IllegalStateException("already in pool mode");
        }
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize must be one or greater");
        }
        this._pool = new LinkedList<GLContext>();
        Threading.invokeOnOpenGLThread((Runnable)new Runnable(){

            public void run() {
                int i = 0;
                while (i < poolSize) {
                    GLContext context = GLGlobalImpl.this._pbuffer.createContext(GLGlobalImpl.this._sharedContext);
                    context.makeCurrent();
                    context.release();
                    GLGlobalImpl.this._pool.offer(context);
                    ++i;
                }
            }
        });
    }

    public GLContext createContext() {
        if (this._pool != null) {
            GLContext context = this._pool.poll();
            if (context == null) {
                throw new JavieRuntimeException("no GLContext is available");
            }
            return context;
        }
        return this._pbuffer.createContext(this._sharedContext);
    }

    public void destroyContext(GLContext context) {
        if (this._pool != null) {
            this._pool.offer(context);
        } else {
            context.destroy();
        }
    }

    public GLCapabilities getCanvasCapabilities() {
        return (GLCapabilities)this._canvasCapabilities.clone();
    }

    public void setCanvasCapabilities(GLCapabilities capabilities) {
        this._canvasCapabilities = (GLCapabilities)capabilities.clone();
    }

    public GLCanvas createCanvas() {
        return new GLCanvas(this._canvasCapabilities, null, this._sharedContext, null);
    }
}

