/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.JavaImageInput;
import ch.kuramo.javie.core.internal.JavaSoundInput;
import ch.kuramo.javie.core.services.MediaFileInputFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaFileInputFactoryImpl
implements MediaFileInputFactory {
    private static final Logger _logger = LoggerFactory.getLogger(MediaFileInputFactoryImpl.class);
    private final List<Class<? extends MediaFileInput>> _inputClasses = Util.newList();
    private final Map<String, Entry> _entries = Util.newMap();
    @Inject
    private Injector _injector;

    public MediaFileInputFactoryImpl() {
        Class<MediaFileInput> clazz = this.classForName("ch.kuramo.javie.core.internal.MacOSXQTCoreVideoInput");
        if (clazz != null) {
            this._inputClasses.add(JavaImageInput.class);
            this._inputClasses.add(clazz);
            this._inputClasses.add(JavaSoundInput.class);
        } else {
            clazz = this.classForName("ch.kuramo.javie.core.internal.WindowsDirectShowInput");
            if (clazz != null) {
                this._inputClasses.add(JavaImageInput.class);
                this._inputClasses.add(JavaSoundInput.class);
                this._inputClasses.add(clazz);
            } else {
                _logger.warn("only JavaImageInput and JavaSoundInput are available");
                this._inputClasses.add(JavaImageInput.class);
                this._inputClasses.add(JavaSoundInput.class);
            }
        }
    }

    private Class<MediaFileInput> classForName(String className) {
        try {
            Class<MediaFileInput> clazz = Class.forName(className);
            return clazz;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public synchronized MediaFileInput get(String key, File file) {
        Entry entry = this._entries.get(key);
        if (entry != null) {
            ++entry.counter;
            return entry.input;
        }
        LinkedHashMap<Class<? extends MediaFileInput>, Throwable> throwables = Util.newLinkedHashMap();
        for (Class<? extends MediaFileInput> clazz : this._inputClasses) {
            MediaFileInput input;
            block6: {
                try {
                    input = (MediaFileInput)this._injector.getInstance(clazz);
                    if (!input.initialize(file)) {
                        input.dispose();
                    }
                    break block6;
                }
                catch (Throwable t) {
                    throwables.put(clazz, t);
                }
                continue;
            }
            this._entries.put(key, new Entry(input));
            return input;
        }
        for (Map.Entry entry2 : throwables.entrySet()) {
            _logger.info(String.format("failed to create MediaFileInput (%s): %s: %s", ((Class)entry2.getKey()).getName(), file.getAbsolutePath(), ((Throwable)entry2.getValue()).toString()));
        }
        return null;
    }

    @Override
    public synchronized void release(String key) {
        Entry entry = this._entries.get(key);
        if (--entry.counter == 0) {
            this._entries.remove(key);
            entry.input.dispose();
        }
    }

    private static class Entry {
        int counter = 1;
        final MediaFileInput input;

        Entry(MediaFileInput input) {
            this.input = input;
        }
    }
}

