/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.output.ProgressMonitor;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.io.File;
import java.util.Arrays;
import javax.media.opengl.GL;

public abstract class PushSourceOutput {
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;

    public void doOutput(final Composition comp, final AudioMode audioMode, File file, ProgressMonitor progMon) {
        this.initialize(comp, audioMode, file);
        final ProgressMonitor monitor = progMon != null ? progMon : ProgressMonitor.NULL;
        Thread audioThread = new Thread(){

            public void run() {
                PushSourceOutput.this.audioLoop(comp, audioMode, monitor);
            }
        };
        audioThread.start();
        try {
            this.videoLoop(comp, monitor);
        }
        catch (Throwable throwable) {
            try {
                audioThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.finish();
            throw throwable;
        }
        try {
            audioThread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.finish();
    }

    protected abstract void initialize(Composition var1, AudioMode var2, File var3);

    protected abstract void finish();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void videoLoop(Composition comp, ProgressMonitor monitor) {
        Time frameDuration = comp.getFrameDuration();
        long numFrames = comp.getDuration().toFrameNumber(frameDuration);
        monitor.beginTask((int)numFrames);
        this._vrContext.activate();
        try {
            GL gl = this._vrContext.getGL();
            comp.prepareExpression(this._vrContext.createInitialExpressionScope(comp));
            long i = 0L;
            while (i < numFrames && !monitor.isCanceled()) {
                Time time = Time.fromFrameNumber((long)i, (Time)frameDuration);
                this._vrContext.reset();
                this._vrContext.setRenderResolution(RenderResolution.FULL);
                this._vrContext.setTime(time);
                VideoBuffer vb = comp.renderVideoFrame();
                try {
                    this._vrSupport.premultiply(vb);
                    gl.glFinish();
                    this.writeVideo(time, vb);
                }
                finally {
                    vb.dispose();
                }
                monitor.currentWork((int)i);
                ++i;
            }
        }
        finally {
            this._vrContext.deactivate();
        }
        monitor.done();
    }

    protected abstract void writeVideo(Time var1, VideoBuffer var2);

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void audioLoop(Composition comp, AudioMode audioMode, ProgressMonitor monitor) {
        long totalFrames = comp.getDuration().toFrameNumber(audioMode.sampleDuration);
        int chunkFrames = audioMode.sampleRate;
        this._arContext.activate();
        try {
            block11: {
                long i;
                block10: {
                    comp.prepareExpression(this._arContext.createInitialExpressionScope(comp));
                    i = 0L;
                    if (!true) break block10;
                    if (i >= totalFrames) return;
                    if (monitor.isCanceled()) break block11;
                }
                do {
                    Time time = Time.fromFrameNumber((long)i, (Time)audioMode.sampleDuration);
                    this._arContext.reset();
                    this._arContext.setAudioMode(audioMode);
                    this._arContext.setTime(time);
                    this._arContext.setFrameCount((int)Math.min((long)chunkFrames, totalFrames - i));
                    this._arContext.setEvaluationResolution(audioMode.sampleRate / 100);
                    AudioBuffer ab = comp.renderAudioChunk();
                    try {
                        if (ab == null) {
                            ab = this.createAudioBufferClear();
                        }
                        this.writeAudio(time, ab);
                        i += (long)ab.getFrameCount();
                    }
                    finally {
                        ab.dispose();
                    }
                    if (i >= totalFrames) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            this._arContext.deactivate();
        }
    }

    protected abstract void writeAudio(Time var1, AudioBuffer var2);

    private AudioBuffer createAudioBufferClear() {
        AudioBuffer ab = this._arSupport.createAudioBuffer();
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                Arrays.fill((short[])ab.getData(), 0, ab.getDataLength(), (short)0);
                break;
            }
            case INT: {
                Arrays.fill((int[])ab.getData(), 0, ab.getDataLength(), 0);
                break;
            }
            case FLOAT: {
                Arrays.fill((float[])ab.getData(), 0, ab.getDataLength(), 0.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + ab.getAudioMode().dataType);
            }
        }
        return ab;
    }
}

