/*
 * Decompiled with CFR 0.152.
 */
package ftgl;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.UnsupportedEncodingException;

public class FT_SfntName
extends Structure {
    public short platform_id;
    public short encoding_id;
    public short language_id;
    public short name_id;
    public Pointer string;
    public int string_len;

    public String stringAsJavaString() {
        switch (this.platform_id) {
            case 1: {
                return this.macintoshPlatformToJavaString();
            }
            case 3: {
                return this.windowsPlatformToJavaString();
            }
        }
        return this.toJavaString("UnicodeBigUnmarked");
    }

    private String macintoshPlatformToJavaString() {
        switch (this.encoding_id) {
            case 0: {
                return this.toJavaString("MacRoman");
            }
            case 1: {
                return this.toJavaString("Shift_JIS");
            }
        }
        return this.toJavaString("ASCII");
    }

    private String windowsPlatformToJavaString() {
        switch (this.encoding_id) {
            case 0: 
            case 1: {
                return this.toJavaString("UnicodeBigUnmarked");
            }
            case 2: {
                return this.toJavaString("MS932");
            }
        }
        return this.toJavaString("ASCII");
    }

    private String toJavaString(String encoding) {
        try {
            return new String(this.string.getByteArray(0L, this.string_len), encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            try {
                return new String(this.string.getByteArray(0L, this.string_len), "ASCII");
            }
            catch (UnsupportedEncodingException e2) {
                throw new Error(e2);
            }
        }
    }
}

