/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.distort;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.GLProgram;
import ch.kuramo.javie.api.annotations.GLShader;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.PolarCoordinates", category="ch.kuramo.javie.api.effectCategory.distort")
public class PolarCoordinates {
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram
    public static final String[] RECT_TO_POLAR = new String[]{"uniform sampler2DRect texture;", "uniform vec2 center;", "uniform float radians_per_px;", "uniform float interp;", "", "void main(void)", "{", "\tfloat sRect = gl_TexCoord[0].s;", "\tfloat tRect = gl_TexCoord[0].t;", "", "\tfloat sPolar = atan(sRect-center.s, tRect-center.t) / radians_per_px + center.s;", "\tfloat tPolar = distance(gl_TexCoord[0].st, center) * 2.0;", "", "\tfloat s = interp*sPolar + (1.0-interp)*sRect;", "\tfloat t = interp*tPolar + (1.0-interp)*tRect;", "\tgl_FragColor = texture2DRect(texture, vec2(s, t));", "}"};
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram
    public static final String[] POLAR_TO_RECT = new String[]{"uniform sampler2DRect texture;", "uniform vec2 center;", "uniform float radians_per_px;", "uniform float maxRadius_div_h;", "uniform float interp;", "", "void main(void)", "{", "\tfloat sPolar = gl_TexCoord[0].s;", "\tfloat tPolar = gl_TexCoord[0].t;", "", "\tfloat theta = (sPolar - center.s) * radians_per_px;", "\tfloat sRect = maxRadius_div_h*tPolar*cos(theta) + center.s;", "\tfloat tRect = maxRadius_div_h*tPolar*sin(theta) + center.t;", "", "\tfloat s = interp*sRect + (1.0-interp)*sPolar;", "\tfloat t = interp*tRect + (1.0-interp)*tPolar;", "\tgl_FragColor = texture2DRect(texture, vec2(s, t));", "}"};
    private final IVideoEffectContext context;
    private final IShaderProgram rectToPolarProgram;
    private final IShaderProgram polarToRectProgram;
    @Property(min="0", max="100")
    private IAnimatableDouble interpolation;
    @Property
    private IAnimatableEnum<TypeOfConversion> typeOfConversion;

    @Inject
    public PolarCoordinates(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.rectToPolarProgram = shaders.getProgram(PolarCoordinates.class, "RECT_TO_POLAR");
        this.polarToRectProgram = shaders.getProgram(PolarCoordinates.class, "POLAR_TO_RECT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVideoBuffer doVideoEffect() {
        double interp = (Double)this.context.value((IAnimatableValue)this.interpolation) / 100.0;
        if (interp == 0.0) {
            return null;
        }
        TypeOfConversion type = (TypeOfConversion)((Object)this.context.value(this.typeOfConversion));
        IShaderProgram program = type == TypeOfConversion.RECT_TO_POLAR ? this.rectToPolarProgram : this.polarToRectProgram;
        IVideoBuffer input = this.context.doPreviousEffect();
        IVideoBuffer buffer = null;
        try {
            VideoBounds bounds = input.getBounds();
            int w = bounds.width;
            int h = bounds.height;
            buffer = this.context.createVideoBuffer(bounds);
            GL gl = this.context.getGL();
            GLU glu = this.context.getGLU();
            VideoEffectUtil.ortho2D(gl, glu, w, h);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            IShaderProgram iShaderProgram = program;
            synchronized (iShaderProgram) {
                gl.glUseProgram(program.getProgram());
                gl.glUniform1i(program.getUniformLocation("texture"), 0);
                gl.glUniform2f(program.getUniformLocation("center"), (float)w / 2.0f, (float)h / 2.0f);
                gl.glUniform1f(program.getUniformLocation("radians_per_px"), (float)Math.toRadians(360.0 / (double)w));
                if (type == TypeOfConversion.POLAR_TO_RECT) {
                    gl.glUniform1f(program.getUniformLocation("maxRadius_div_h"), (float)(Math.sqrt(w * w + h * h) * 0.5 / (double)h));
                }
                gl.glUniform1f(program.getUniformLocation("interp"), (float)interp);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)w, 0.0f);
                gl.glVertex2f((float)w, 0.0f);
                gl.glTexCoord2f((float)w, (float)h);
                gl.glVertex2f((float)w, (float)h);
                gl.glTexCoord2f(0.0f, (float)h);
                gl.glVertex2f(0.0f, (float)h);
                gl.glEnd();
                gl.glFinish();
                gl.glUseProgram(0);
            }
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
            IVideoBuffer output = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            input.dispose();
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeOfConversion {
        RECT_TO_POLAR,
        POLAR_TO_RECT;

    }
}

