/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.keying.KeyingShaders;
import ch.kuramo.javie.effects.keying.Smoothing;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlueGreenScreenKeyBase {
    private final IVideoEffectContext context;
    private final IShaderProgram keyingProgram;
    private final IShaderProgram maskOnlyProgram;
    private final IShaderProgram smoothingLowProgram;
    private final IShaderProgram smoothingHighProgram;

    protected BlueGreenScreenKeyBase(IVideoEffectContext context, IShaderRegistry shaders, boolean blue) {
        this.context = context;
        if (blue) {
            this.keyingProgram = shaders.getProgram(KeyingShaders.class, "BLUE_SCREEN_KEY");
            this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "BLUE_SCREEN_KEY_MASK_ONLY");
        } else {
            this.keyingProgram = shaders.getProgram(KeyingShaders.class, "GREEN_SCREEN_KEY");
            this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "GREEN_SCREEN_KEY_MASK_ONLY");
        }
        this.smoothingLowProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_LOW");
        this.smoothingHighProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_HIGH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IVideoBuffer doKeying(IAnimatableDouble threshold, IAnimatableDouble cutoff, IAnimatableBoolean maskOnly, IAnimatableEnum<Smoothing> smoothing) {
        double t = (Double)this.context.value((IAnimatableValue)threshold) / 100.0;
        double c = (Double)this.context.value((IAnimatableValue)cutoff) / 100.0;
        boolean mask = (Boolean)this.context.value((IAnimatableValue)maskOnly);
        Smoothing sm = mask ? Smoothing.NONE : (Smoothing)((Object)this.context.value(smoothing));
        double t_minus_c = t - c;
        if (t_minus_c == 0.0) {
            if (t == 0.0) {
                t_minus_c = Double.POSITIVE_INFINITY;
            } else if (t == 1.0) {
                t = Double.POSITIVE_INFINITY;
            }
        }
        IVideoBuffer input = this.context.doPreviousEffect();
        IVideoBuffer buf = null;
        try {
            IShaderProgram program;
            VideoBounds bounds = input.getBounds();
            int w = bounds.width;
            int h = bounds.height;
            buf = this.context.createVideoBuffer(bounds);
            GL gl = this.context.getGL();
            GLU glu = this.context.getGLU();
            VideoEffectUtil.ortho2D(gl, glu, w, h);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, buf.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            IShaderProgram iShaderProgram = program = mask ? this.maskOnlyProgram : this.keyingProgram;
            synchronized (iShaderProgram) {
                gl.glUseProgram(program.getProgram());
                gl.glUniform1i(program.getUniformLocation("texture"), 0);
                gl.glUniform1f(program.getUniformLocation("threshold"), (float)t);
                gl.glUniform1f(program.getUniformLocation("t_minus_c"), (float)t_minus_c);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)w, 0.0f);
                gl.glVertex2f((float)w, 0.0f);
                gl.glTexCoord2f((float)w, (float)h);
                gl.glVertex2f((float)w, (float)h);
                gl.glTexCoord2f(0.0f, (float)h);
                gl.glVertex2f(0.0f, (float)h);
                gl.glEnd();
                gl.glFinish();
                gl.glUseProgram(0);
            }
            switch (sm) {
                case LOW: {
                    program = this.smoothingLowProgram;
                    break;
                }
                case HIGH: {
                    program = this.smoothingHighProgram;
                    break;
                }
                default: {
                    program = null;
                }
            }
            if (program != null) {
                IVideoBuffer tmp = input;
                input = buf;
                buf = tmp;
                gl.glFramebufferTexture2DEXT(36160, 36064, 34037, buf.getTexture(), 0);
                gl.glBindTexture(34037, input.getTexture());
                IShaderProgram iShaderProgram2 = program;
                synchronized (iShaderProgram2) {
                    gl.glUseProgram(program.getProgram());
                    gl.glUniform1i(program.getUniformLocation("texture"), 0);
                    gl.glBegin(7);
                    gl.glTexCoord2f(0.0f, 0.0f);
                    gl.glVertex2f(0.0f, 0.0f);
                    gl.glTexCoord2f((float)w, 0.0f);
                    gl.glVertex2f((float)w, 0.0f);
                    gl.glTexCoord2f((float)w, (float)h);
                    gl.glVertex2f((float)w, (float)h);
                    gl.glTexCoord2f(0.0f, (float)h);
                    gl.glVertex2f(0.0f, (float)h);
                    gl.glEnd();
                    gl.glFinish();
                    gl.glUseProgram(0);
                }
            }
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
            IVideoBuffer output = buf;
            buf = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            input.dispose();
            if (buf != null) {
                buf.dispose();
            }
        }
    }
}

