/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.GLProgram;
import ch.kuramo.javie.api.annotations.GLShader;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.Mosaic", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Mosaic {
    @GLShader(value=GLShader.ShaderType.FRAGMENT_SHADER)
    @GLProgram
    public static final String[] MOSAIC_SHARP_COLORS = new String[]{"uniform sampler2DRect texture;", "uniform float hSize;", "uniform float vSize;", "", "void main(void)", "{", "\tfloat s = (floor(gl_TexCoord[0].s/hSize)+0.5)*hSize;", "\tfloat t = (floor(gl_TexCoord[0].t/vSize)+0.5)*vSize;", "\tgl_FragColor = texture2DRect(texture, vec2(s, t));", "}"};
    private final IVideoEffectContext context;
    private final IShaderRegistry shaders;
    private final IShaderProgram sharpColorsProgram;
    @Property(value="10", min="1")
    private IAnimatableInteger horizontalBlocks;
    @Property(value="10", min="1")
    private IAnimatableInteger verticalBlocks;
    @Property
    private IAnimatableBoolean sharpColors;

    @Inject
    public Mosaic(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.shaders = shaders;
        this.sharpColorsProgram = shaders.getProgram(Mosaic.class, "MOSAIC_SHARP_COLORS");
    }

    public IVideoBuffer doVideoEffect() {
        int hBlocks = (Integer)this.context.value((IAnimatableValue)this.horizontalBlocks);
        int vBlocks = (Integer)this.context.value((IAnimatableValue)this.verticalBlocks);
        boolean sharpColors = (Boolean)this.context.value((IAnimatableValue)this.sharpColors);
        if (sharpColors) {
            return this.doSharpColorsMosaic(hBlocks, vBlocks);
        }
        return this.doAverageColorsMosaic(hBlocks, vBlocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IVideoBuffer doSharpColorsMosaic(int hBlocks, int vBlocks) {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        int w = bounds.width;
        int h = bounds.height;
        hBlocks = Math.min(hBlocks, w);
        vBlocks = Math.min(vBlocks, h);
        if (hBlocks == w && vBlocks == h) {
            return input;
        }
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(bounds);
            GL gl = this.context.getGL();
            GLU glu = this.context.getGLU();
            VideoEffectUtil.ortho2D(gl, glu, w, h);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, buffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, input.getTexture());
            IShaderProgram iShaderProgram = this.sharpColorsProgram;
            synchronized (iShaderProgram) {
                gl.glUseProgram(this.sharpColorsProgram.getProgram());
                gl.glUniform1i(this.sharpColorsProgram.getUniformLocation("texture"), 0);
                gl.glUniform1f(this.sharpColorsProgram.getUniformLocation("hSize"), (float)w / (float)hBlocks);
                gl.glUniform1f(this.sharpColorsProgram.getUniformLocation("vSize"), (float)h / (float)vBlocks);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)w, 0.0f);
                gl.glVertex2f((float)w, 0.0f);
                gl.glTexCoord2f((float)w, (float)h);
                gl.glVertex2f((float)w, (float)h);
                gl.glTexCoord2f(0.0f, (float)h);
                gl.glVertex2f(0.0f, (float)h);
                gl.glEnd();
                gl.glFinish();
                gl.glUseProgram(0);
            }
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
            IVideoBuffer output = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            input.dispose();
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer doAverageColorsMosaic(int hBlocks, int vBlocks) {
        IVideoBuffer input = this.context.doPreviousEffect();
        IVideoBuffer buffer = null;
        try {
            VideoBounds bounds = input.getBounds();
            int w = bounds.width;
            int h = bounds.height;
            hBlocks = Math.min(hBlocks, w);
            vBlocks = Math.min(vBlocks, h);
            if (hBlocks != w || vBlocks != h) {
                buffer = this.context.createVideoBuffer(new VideoBounds(hBlocks, vBlocks));
                this.average(input, buffer);
                this.scale(buffer, input);
            }
            IVideoBuffer output = input;
            input = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void average(IVideoBuffer src, IVideoBuffer dst) {
        GL gl = this.context.getGL();
        GLU glu = this.context.getGLU();
        IVideoBuffer src0 = src;
        IVideoBuffer tmpBuf = null;
        try {
            IShaderProgram program;
            VideoBounds srcBounds = src.getBounds();
            VideoBounds dstBounds = dst.getBounds();
            int hBlocks = dstBounds.width;
            int vBlocks = dstBounds.height;
            int hbs = (srcBounds.width + hBlocks - 1) / hBlocks;
            int vbs = (srcBounds.height + vBlocks - 1) / vBlocks;
            if (hbs > 7 || vbs > 7) {
                tmpBuf = this.context.createVideoBuffer(new VideoBounds(hbs > 7 ? hBlocks * 7 : hBlocks, vbs > 7 ? vBlocks * 7 : vBlocks));
                this.average(src, tmpBuf);
                src = tmpBuf;
                srcBounds = src.getBounds();
                hbs = (srcBounds.width + hBlocks - 1) / hBlocks;
                vbs = (srcBounds.height + vBlocks - 1) / vBlocks;
            }
            int ksize = hbs * vbs;
            float[] kernel = new float[ksize];
            float[] offset = new float[ksize * 2];
            int j = 0;
            while (j < vbs) {
                int i = 0;
                while (i < hbs) {
                    int k = j * hbs + i;
                    kernel[k] = 1.0f / (float)ksize;
                    offset[k * 2] = i - hbs / 2;
                    offset[k * 2 + 1] = j - vbs / 2;
                    ++i;
                }
                ++j;
            }
            VideoEffectUtil.setClampToEdge(src, gl);
            VideoEffectUtil.ortho2D(gl, glu, hBlocks, vBlocks);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, dst.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, src.getTexture());
            IShaderProgram iShaderProgram = program = this.shaders.getProgram(VideoEffectUtil.class, "CONVOLUTION");
            synchronized (iShaderProgram) {
                gl.glUseProgram(program.getProgram());
                gl.glUniform1i(program.getUniformLocation("texture"), 0);
                gl.glUniform1i(program.getUniformLocation("ksize"), ksize);
                gl.glUniform1fv(program.getUniformLocation("kernel[0]"), ksize, kernel, 0);
                gl.glUniform2fv(program.getUniformLocation("offset[0]"), ksize * 2, offset, 0);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)srcBounds.width, 0.0f);
                gl.glVertex2f((float)dstBounds.width, 0.0f);
                gl.glTexCoord2f((float)srcBounds.width, (float)srcBounds.height);
                gl.glVertex2f((float)dstBounds.width, (float)dstBounds.height);
                gl.glTexCoord2f(0.0f, (float)srcBounds.height);
                gl.glVertex2f(0.0f, (float)dstBounds.height);
                gl.glEnd();
                gl.glFinish();
                gl.glUseProgram(0);
            }
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
        }
        finally {
            if (tmpBuf != null) {
                tmpBuf.dispose();
            }
            VideoEffectUtil.setClampToBorder(src0, gl);
        }
    }

    private void scale(IVideoBuffer src, IVideoBuffer dst) {
        GL gl = this.context.getGL();
        GLU glu = this.context.getGLU();
        VideoEffectUtil.setNearest(src, gl);
        VideoBounds srcBounds = src.getBounds();
        VideoBounds dstBounds = dst.getBounds();
        VideoEffectUtil.ortho2D(gl, glu, dstBounds.width, dstBounds.height);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, dst.getTexture(), 0);
        gl.glDrawBuffer(36064);
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, src.getTexture());
        gl.glEnable(34037);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex2f(0.0f, 0.0f);
        gl.glTexCoord2f((float)srcBounds.width, 0.0f);
        gl.glVertex2f((float)dstBounds.width, 0.0f);
        gl.glTexCoord2f((float)srcBounds.width, (float)srcBounds.height);
        gl.glVertex2f((float)dstBounds.width, (float)dstBounds.height);
        gl.glTexCoord2f(0.0f, (float)srcBounds.height);
        gl.glVertex2f(0.0f, (float)dstBounds.height);
        gl.glEnd();
        gl.glActiveTexture(33984);
        gl.glBindTexture(34037, 0);
        gl.glDisable(34037);
        gl.glFramebufferTexture2DEXT(36160, 36064, 34037, 0, 0);
    }
}

