/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.core.JavieRuntimeException;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Widget;

public class ColorDialogBugFix {
    public static void patch() {
        String platform = SWT.getPlatform();
        if (platform.equals("cocoa")) {
            ColorDialogBugFix.cocoa();
        }
    }

    private static void cocoa() {
        try {
            ClassLoader loader = Widget.class.getClassLoader();
            ClassPool pool = new ClassPool();
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass targetClass = pool.get("org.eclipse.swt.widgets.ColorDialog");
            CtMethod method = targetClass.getDeclaredMethod("open", new CtClass[0]);
            method.instrument(new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getClassName().equals("org.eclipse.swt.internal.cocoa.NSApplication") && m.getMethodName().equals("runModalForWindow")) {
                        String src = "$_ = $proceed($$); selected = true;";
                        m.replace(src);
                    }
                }

                public void edit(NewExpr e) throws CannotCompileException {
                    if (e.getClassName().equals("org.eclipse.swt.graphics.RGB")) {
                        String src = "$_ = new org.eclipse.swt.graphics.RGB(Math.round(color.redComponent() * 255),Math.round(color.greenComponent() * 255),Math.round(color.blueComponent() * 255));";
                        e.replace(src);
                    }
                }
            });
            targetClass.toClass(loader, null);
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }
}

