/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.core.JavieRuntimeException;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;

public class DropTargetEnhancement {
    public static final int FEEDBACK_PARENT = 32;

    public static void patch() {
        String platform = SWT.getPlatform();
        if (platform.equals("cocoa")) {
            DropTargetEnhancement.cocoa();
        } else if (platform.equals("win32")) {
            DropTargetEnhancement.win32();
        }
    }

    private static void cocoa() {
        try {
            ClassLoader loader = DND.class.getClassLoader();
            ClassPool pool = new ClassPool();
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass targetClass = pool.get("org.eclipse.swt.dnd.DropTarget");
            CtMethod method = targetClass.getDeclaredMethod("outlineView_validateDrop_proposedItem_proposedChildIndex");
            method.instrument(new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getClassName().equals("org.eclipse.swt.widgets.Tree") && m.getMethodName().equals("getItem")) {
                        String src = "org.eclipse.swt.widgets.TreeItem tmpItem = $proceed($$);if ((feedback & %d) != 0 && tmpItem != null) { $_ = tmpItem.getParentItem(); }else { $_ = tmpItem; }";
                        m.replace(String.format(src, 32));
                    }
                }
            });
            targetClass.toClass(loader, null);
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private static void win32() {
        try {
            ClassLoader loader = DND.class.getClassLoader();
            ClassPool pool = new ClassPool();
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass targetClass = pool.get("org.eclipse.swt.dnd.TreeDropTargetEffect");
            CtMethod method = targetClass.getDeclaredMethod("dragOver");
            method.instrument(new ExprEditor(){
                private boolean done;

                public void edit(MethodCall m) throws CannotCompileException {
                    if (!this.done && m.getClassName().equals("org.eclipse.swt.internal.win32.OS") && m.getMethodName().equals("SendMessage")) {
                        String src = "$_ = $proceed($$);if ((effect & %d) != 0 && lpht.hItem != -1) {\torg.eclipse.swt.widgets.TreeItem item = (org.eclipse.swt.widgets.TreeItem)\t\t\ttree.getDisplay().findWidget(tree.handle, lpht.hItem);\tif (item != null) {\t\titem = item.getParentItem();\t\tlpht.hItem = (item != null) ? item.handle : -1;\t}}";
                        m.replace(String.format(src, 32));
                        this.done = true;
                    }
                }
            });
            targetClass.toClass(loader, null);
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private DropTargetEnhancement() {
    }
}

