/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.services.Font;
import ch.kuramo.javie.core.services.FontList;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetAnimatableValuesOperation
extends ProjectOperation {
    private final String _compId;
    private final Object[][] _properties;
    private final String[] _savedAvalues;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;
    @Inject
    private FontList _fontList;

    public ResetAnimatableValuesOperation(ProjectManager pm, LayerComposition comp, Object[][] properties) {
        super(pm, "\u30ea\u30bb\u30c3\u30c8");
        InjectorHolder.getInjector().injectMembers((Object)this);
        if (properties.length == 0) {
            this._compId = null;
            this._properties = null;
            this._savedAvalues = null;
            this._noEffect = true;
            return;
        }
        pm.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._properties = new Object[properties.length][];
        this._savedAvalues = new String[properties.length];
        int i = 0;
        while (i < properties.length) {
            Layer layer = (Layer)properties[i][0];
            Integer effectIndex = (Integer)properties[i][1];
            String property = (String)properties[i][2];
            if (pm.checkLayer(layer) != comp) {
                throw new IllegalArgumentException();
            }
            if (effectIndex == -1) {
                AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
                this._savedAvalues[i] = this._encoder.encodeElement((Object)avalue);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
                this._savedAvalues[i] = this._encoder.encodeElement((Object)avalue);
            }
            this._properties[i] = new Object[]{layer.getId(), effectIndex, property};
            ++i;
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.resetOrRestore(true, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.resetOrRestore(false, project, pm);
        return Status.OK_STATUS;
    }

    private void resetOrRestore(boolean reset, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Object[][] data = pm != null ? new Object[this._properties.length][] : null;
        int i = 0;
        int n = this._properties.length;
        while (i < n) {
            String expr1;
            AnimatableValue avalue;
            Layer layer = comp.getLayer((String)this._properties[i][0]);
            Integer effectIndex = (Integer)this._properties[i][1];
            String property = (String)this._properties[i][2];
            if (effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            String string = expr1 = pm != null ? avalue.getExpression() : null;
            if (reset) {
                if (effectIndex == -1) {
                    this.resetLayerProperty(comp, layer, property, avalue);
                } else {
                    avalue.reset();
                }
                if (pm != null) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = layer;
                    objectArray[1] = effectIndex;
                    objectArray[2] = property;
                    data[i] = objectArray;
                }
            } else {
                this.restore(this._savedAvalues[i], avalue);
                if (pm != null) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = layer;
                    objectArray[1] = effectIndex;
                    objectArray[2] = property;
                    data[i] = objectArray;
                }
            }
            if (pm != null) {
                String expr2 = avalue.getExpression();
                if (expr1 != null && !expr1.equals(expr2) || expr1 == null && expr2 != null) {
                    if (effectIndex == -1) {
                        pm.fireLayerExpressionChange(layer, property);
                    } else {
                        pm.fireEffectExpressionChange((EffectableLayer)layer, effectIndex, property);
                    }
                }
            }
            ++i;
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, data);
        }
    }

    private void resetLayerProperty(LayerComposition comp, Layer layer, String property, AnimatableValue<?> avalue) {
        double w = comp.getSize().width;
        double h = comp.getSize().height;
        if (layer instanceof TextLayer && property.equals("font")) {
            Font font = this._fontList.defaultFont();
            if (font != null) {
                ((AnimatableString)avalue).reset((Object)font.psName);
                return;
            }
        } else {
            if (layer instanceof TransformableLayer && property.equals("position")) {
                ((AnimatableVec3d)avalue).reset((Object)new Vec3d(w / 2.0, h / 2.0));
                return;
            }
            if (layer instanceof MediaLayer) {
                VideoBounds bounds;
                MediaLayer ml = (MediaLayer)layer;
                VideoBounds videoBounds = bounds = LayerNature.isVideoNature((Layer)layer) ? ml.getMediaInput().getVideoFrameBounds() : null;
                if (bounds != null) {
                    if (property.equals("anchorPoint")) {
                        ((AnimatableVec3d)avalue).reset((Object)new Vec3d((double)bounds.width / 2.0 + bounds.x, (double)bounds.height / 2.0 + bounds.y));
                        return;
                    }
                    if (property.equals("depthBase") && LayerNature.isThreeD((Layer)ml)) {
                        ((AnimatableVec2d)avalue).reset((Object)new Vec2d((double)bounds.width / 2.0 + bounds.x, (double)bounds.height / 2.0 + bounds.y));
                        return;
                    }
                }
            } else if (layer instanceof CameraLayer) {
                double fovx = 39.6;
                double zoom = w / (2.0 * Math.tan(Math.toRadians(fovx / 2.0)));
                if (property.equals("pointOfInterest")) {
                    ((AnimatableVec3d)avalue).reset((Object)new Vec3d(w / 2.0, h / 2.0));
                    return;
                }
                if (property.equals("position")) {
                    ((AnimatableVec3d)avalue).reset((Object)new Vec3d(w / 2.0, h / 2.0, -zoom));
                    return;
                }
                if (property.equals("zoom")) {
                    ((AnimatableDouble)avalue).reset((Object)zoom);
                    return;
                }
                if (property.equals("near")) {
                    ((AnimatableDouble)avalue).reset((Object)(zoom / 2.0));
                    return;
                }
                if (property.equals("far")) {
                    ((AnimatableDouble)avalue).reset((Object)(zoom * 10.0));
                    return;
                }
            }
        }
        avalue.reset();
    }

    private <A extends AnimatableValue<V>, V> void restore(String data, A dst) throws ExecutionException {
        try {
            AnimatableValue src = (AnimatableValue)this._decoder.decodeElement((CharSequence)data, dst.getClass());
            dst.reset(src.getStaticValue());
            dst.setExpression(src.getExpression());
            for (Keyframe kf : src.getKeyframes()) {
                dst.putKeyframe(kf);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding AnimatableValue data", (Throwable)e);
        }
    }
}

