/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.views.layercomp.AnimatableDoubleElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.TimeCode;
import org.eclipse.swt.graphics.GC;

class TimeRemapElementDelegate
extends AnimatableDoubleElementDelegate {
    private final MediaLayer layer;
    private final Time frameDuration;

    public TimeRemapElementDelegate(AnimatableValueElement element, String name, AnimatableDouble avalue, MediaLayer layer) {
        super(element, name, avalue);
        this.layer = layer;
        if (LayerNature.isVideoNature((Layer)layer)) {
            this.frameDuration = layer.getMediaInput().getVideoFrameDuration();
        } else {
            LayerComposition comp = (LayerComposition)element.viewer.getData("LAYER_COMPOSITION");
            this.frameDuration = comp.getFrameDuration();
        }
    }

    private String toTimeCode(double sec) {
        Time time = new Time(Math.round(sec * (double)this.frameDuration.timeScale), this.frameDuration.timeScale);
        return TimeCode.toTimeCode((Time)time, (Time)this.frameDuration);
    }

    private Time parseTimeCode(String str) {
        long frames = TimeCode.parseTimeCode((String)str, (Time)this.frameDuration);
        return Time.fromFrameNumber((long)frames, (Time)this.frameDuration);
    }

    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        if (LayerNature.isTimeRemapEnabled((Layer)this.layer)) {
            super.drawValue(gc, x, y, height, focused);
        }
    }

    protected int drawValue(GC gc, int x, int y, int height, boolean focused, Double value, int precision, String unit) {
        x = this.drawValue(gc, x, y, height, focused, this.toTimeCode(value));
        if (unit != null) {
            x = this.drawString(gc, x + 1, y, height, unit);
        }
        return x;
    }

    protected Double dragGesture(double dx, double dy) {
        return (Double)this.originalValue + this.frameDuration.toSecond() * this.increment * dx;
    }

    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            return this.toTimeCode((Double)this.value);
        }
        return super.getCellEditorValue(columnIndex);
    }

    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            if (!value.equals(this.toTimeCode((Double)this.value))) {
                this.modifyValue(this.parseTimeCode((String)value).toSecond());
            }
        } else {
            super.setCellEditorValue(columnIndex, value);
        }
    }
}

