/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.VideoLayerComposer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.AbstractMediaLayer;
import ch.kuramo.javie.core.services.VideoRenderContext;
import com.google.inject.Inject;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="mediaItemLayer")
public class MediaItemLayerImpl
extends AbstractMediaLayer
implements MediaItemLayer {
    private String _itemId;
    private MediaItem _mediaItem;
    private boolean _ctcr;
    @Inject
    private VideoRenderContext _vrContext;

    protected void initialize(boolean videoAvailable, boolean audioAvailable) {
        throw new UnsupportedOperationException("Use initialize(MediaItem) method instead.");
    }

    public void initialize(MediaItem mediaItem) {
        MediaInput input = mediaItem.getMediaInput();
        boolean videoAvailable = input.isVideoAvailable();
        boolean audioAvailable = input.isAudioAvailable();
        if (!videoAvailable && !audioAvailable) {
            throw new IllegalArgumentException("No video nor audio is available.");
        }
        super.initialize(videoAvailable, audioAvailable);
        this._itemId = mediaItem.getId();
        this._mediaItem = mediaItem;
        this.setName(mediaItem.getName());
    }

    public String getItemId() {
        return this._itemId;
    }

    public void setItemId(String itemId) {
        this._itemId = itemId;
    }

    @JSONHint(ignore=true)
    public MediaItem getItem() {
        return this._mediaItem;
    }

    public boolean isCTCR() {
        return this._ctcr;
    }

    public void setCTCR(boolean ctcr) {
        this._ctcr = ctcr;
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._mediaItem.getMediaInput();
    }

    @JSONHint(ignore=true)
    public boolean isPrecompositionLayer() {
        return this.getPrecomposition() != null;
    }

    private LayerComposition getPrecomposition() {
        Composition comp;
        if (this._mediaItem instanceof CompositionItem && (comp = ((CompositionItem)this._mediaItem).getComposition()) instanceof LayerComposition) {
            return (LayerComposition)comp;
        }
        return null;
    }

    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        super.afterDecode(p, c);
        this._mediaItem = (MediaItem)p.getItem(this._itemId);
        if (this._mediaItem == null) {
            throw new ProjectDecodeException("no such MediaItem found: id=" + this._itemId);
        }
    }

    public void prepareExpression(ExpressionScope scope) {
        ExpressionScope preCompScope;
        super.prepareExpression(scope);
        LayerComposition preComp = this.getPrecomposition();
        if (preComp != null && (preCompScope = scope.createPrecompositionScope(preComp)) != null) {
            preComp.prepareExpression(preCompScope);
        }
    }

    public void setupVideoRenderer(VideoLayerComposer composer, Camera camera, CollapseTransformation ct) {
        LayerComposition preComp;
        if (LayerNature.isCTCR(this) && (preComp = this.getPrecomposition()) != null) {
            this.setupCollapseTransformation(composer, camera, ct, preComp);
            return;
        }
        super.setupVideoRenderer(composer, camera, ct);
    }

    private void setupCollapseTransformation(final VideoLayerComposer composer, final Camera camera, final CollapseTransformation ct, final LayerComposition preComp) {
        final double opacity = ct != null ? (Double)this.getOpacity().value(this._vrContext) / 100.0 * ct.getOpacity() : (Double)this.getOpacity().value(this._vrContext) / 100.0;
        final CollapseTransformation ct2 = new CollapseTransformation(){

            public CollapseTransformation getParent() {
                return ct;
            }

            public MediaItemLayer getLayer() {
                return MediaItemLayerImpl.this;
            }

            public double getOpacity() {
                return opacity;
            }
        };
        this._vrContext.saveAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                preComp.setupCollapseTransformation(composer, camera, ct2);
                return null;
            }
        });
    }
}

