/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.services.EffectClassProcessor;
import ch.kuramo.javie.core.services.EffectRegistry;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.scannotation.AnnotationDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectRegistryImpl
implements EffectRegistry {
    private final Map<String, EffectDescriptor> _registry = Util.newLinkedHashMap();
    @Inject
    private Injector _injector;

    @Override
    public void searchClasses(AnnotationDB db, ClassLoader cl) {
        Set classNames = (Set)db.getAnnotationIndex().get(ch.kuramo.javie.api.annotations.Effect.class.getName());
        if (classNames == null) {
            return;
        }
        List<EffectDescriptor> descriptors = Util.newList();
        ClassPool pool = new ClassPool();
        pool.appendClassPath((ClassPath)new LoaderClassPath(cl));
        ClassLoader cl2 = Effect.class.getClassLoader();
        if (cl2 != cl) {
            pool.appendClassPath((ClassPath)new LoaderClassPath(cl2));
        }
        block2: for (String className : classNames) {
            CtClass cc;
            try {
                cc = pool.get(className);
            }
            catch (NotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            Object[] objectArray = cc.getAvailableAnnotations();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object anno = objectArray[n2];
                if (anno instanceof ch.kuramo.javie.api.annotations.Effect) {
                    String type = ((ch.kuramo.javie.api.annotations.Effect)anno).id();
                    if (type.equals("")) {
                        type = className;
                    } else if (!type.contains(".")) {
                        type = String.valueOf(cc.getPackageName()) + "." + type;
                    }
                    descriptors.add(new EffectClassProcessor(cl, type, cc).process());
                    continue block2;
                }
                ++n2;
            }
        }
        Collections.sort(descriptors, new Comparator<EffectDescriptor>(){

            @Override
            public int compare(EffectDescriptor o1, EffectDescriptor o2) {
                return o1.getType().compareTo(o2.getType());
            }
        });
        for (EffectDescriptor ed : descriptors) {
            this._registry.put(ed.getType(), ed);
        }
    }

    @Override
    public Collection<EffectDescriptor> getEffectDescriptors() {
        return Collections.unmodifiableCollection(this._registry.values());
    }

    @Override
    public EffectDescriptor getEffectDescriptor(String type) {
        return this._registry.get(type);
    }

    @Override
    public Effect newEffect(String type) {
        EffectDescriptor desc = this._registry.get(type);
        if (desc == null) {
            return null;
        }
        return (Effect)this._injector.getInstance(desc.getEffectClass());
    }
}

