/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.SynchronousTaskException;
import ch.kuramo.javie.core.services.SynchronousTaskThread;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousTaskThreadImpl
extends Thread
implements SynchronousTaskThread {
    private static final Logger _logger = LoggerFactory.getLogger(SynchronousTaskThreadImpl.class);
    private final Object _lock = new Object();
    private final Queue<TaskRunner<?>> _queue = Util.newLinkedList();
    private boolean _exit = false;

    public SynchronousTaskThreadImpl() {
    }

    public SynchronousTaskThreadImpl(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit() {
        Object object = this._lock;
        synchronized (object) {
            if (!this._exit) {
                this._exit = true;
                this._lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T exit(SynchronousTaskThread.Task<T> task) throws SynchronousTaskException {
        TaskRunner runner = new TaskRunner(task);
        Object object = this._lock;
        synchronized (object) {
            block4: {
                if (!this._exit) break block4;
                return null;
            }
            this._queue.add(runner);
            this._exit = true;
            this._lock.notify();
        }
        return this.waitRunner(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(SynchronousTaskThread.Task<T> task) throws SynchronousTaskException, IllegalStateException {
        TaskRunner runner = new TaskRunner(task);
        Object object = this._lock;
        synchronized (object) {
            if (this._exit) {
                throw new IllegalStateException("this SynchronousTaskThread already exited.");
            }
            this._queue.add(runner);
            this._lock.notify();
        }
        return this.waitRunner(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T waitRunner(TaskRunner<T> runner) throws SynchronousTaskException {
        TaskRunner<T> taskRunner = runner;
        synchronized (taskRunner) {
            while (!((TaskRunner)runner).isFinished()) {
                try {
                    runner.wait();
                }
                catch (InterruptedException e) {
                    _logger.warn("unexpected interruption", (Throwable)e);
                }
            }
        }
        if (((TaskRunner)runner).getThrowable() != null) {
            throw new SynchronousTaskException(((TaskRunner)runner).getThrowable());
        }
        return (T)((TaskRunner)runner).getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            TaskRunner<?> runner;
            Object object = this._lock;
            synchronized (object) {
                while (true) {
                    if ((runner = this._queue.poll()) != null || this._exit) {
                        if (runner != null) break;
                        return;
                    }
                    try {
                        this._lock.wait();
                    }
                    catch (InterruptedException e) {
                        _logger.warn("unexpected interruption", (Throwable)e);
                    }
                }
            }
            ((TaskRunner)runner).run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskRunner<T> {
        private final SynchronousTaskThread.Task<T> _task;
        private T _result;
        private Throwable _throwable;
        private boolean _finished;

        private TaskRunner(SynchronousTaskThread.Task<T> task) {
            this._task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            try {
                this._result = this._task.run();
            }
            catch (Throwable t) {
                this._throwable = t;
            }
            TaskRunner taskRunner = this;
            synchronized (taskRunner) {
                this._finished = true;
                this.notify();
            }
        }

        private T getResult() {
            return this._result;
        }

        private Throwable getThrowable() {
            return this._throwable;
        }

        private boolean isFinished() {
            return this._finished;
        }
    }
}

