/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ExistingIUInProfileAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.UninstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class UninstallAction
extends ExistingIUInProfileAction {
    public UninstallAction(Policy policy, ISelectionProvider selectionProvider, String profileId) {
        super(ProvUI.UNINSTALL_COMMAND_LABEL, policy, selectionProvider, profileId);
        this.setToolTipText(ProvUI.UNINSTALL_COMMAND_TOOLTIP);
    }

    protected String getTaskName() {
        return ProvUIMessages.UninstallIUProgress;
    }

    protected int performAction(IInstallableUnit[] ius, String targetProfileId, PlannerResolutionOperation resolution) {
        UninstallWizard wizard = new UninstallWizard(this.getPolicy(), targetProfileId, ius, resolution);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(this.getShell(), wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.uinstall_wizard_context");
        return dialog.open();
    }

    protected ProfileChangeRequest getProfileChangeRequest(IInstallableUnit[] ius, String targetProfileId, MultiStatus status, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)ProvUIMessages.ProfileChangeRequestBuildingRequest, (int)1);
        ProfileChangeRequest request = null;
        try {
            request = ProfileChangeRequest.createByProfileId((String)targetProfileId);
            request.removeInstallableUnits(ius);
            String key = this.getPolicy().getQueryContext().getVisibleInstalledIUProperty();
            int i = 0;
            while (i < ius.length) {
                request.removeInstallableUnitProfileProperty(ius[i], key);
                ++i;
            }
        }
        finally {
            sub.done();
        }
        return request;
    }

    protected int getLockConstant() {
        return 1;
    }
}

