/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.blurSharpen.BlurDimensions;
import ch.kuramo.javie.effects.blurSharpen.BlurUtil;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.GaussianBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class GaussianBlur {
    @Property(min="0", max="500")
    private IAnimatableDouble blurriness;
    @Property
    private IAnimatableEnum<BlurDimensions> blurDimensions;
    @Property
    private IAnimatableBoolean repeatEdgePixels;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IShaderRegistry shaders;

    @Inject
    public GaussianBlur(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.shaders = shaders;
    }

    public VideoBounds getVideoBounds() {
        double blur = (Double)this.context.value((IAnimatableValue)this.blurriness);
        if (blur == 0.0) {
            return null;
        }
        if (((Boolean)this.context.value((IAnimatableValue)this.repeatEdgePixels)).booleanValue()) {
            return null;
        }
        BlurDimensions dimensions = (BlurDimensions)((Object)this.context.value(this.blurDimensions));
        boolean horz = dimensions != BlurDimensions.VERTICAL;
        boolean vert = dimensions != BlurDimensions.HORIZONTAL;
        boolean fast = blur > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        blur = this.context.getRenderResolution().scale(blur);
        VideoBounds bounds = this.context.getPreviousBounds();
        int sampleRatio = 1;
        if (fast) {
            int[] nArray = BlurUtil.getDownSampleFactors(blur);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int factor = nArray[n2];
                int hFactor = horz ? factor : 1;
                int vFactor = vert ? factor : 1;
                bounds = new VideoBounds(bounds.x / (double)hFactor, bounds.y / (double)vFactor, (bounds.width + hFactor - 1) / hFactor, (bounds.height + vFactor - 1) / vFactor);
                sampleRatio *= factor;
                ++n2;
            }
            blur /= (double)sampleRatio;
        }
        int radius = (int)Math.ceil(blur);
        bounds = VideoEffectUtil.expandBounds(bounds, radius, horz, vert);
        int hRatio = horz ? sampleRatio : 1;
        int vRatio = vert ? sampleRatio : 1;
        return new VideoBounds(bounds.x * (double)hRatio, bounds.y * (double)vRatio, bounds.width * hRatio, bounds.height * vRatio);
    }

    public IVideoBuffer doVideoEffect() {
        double blur = (Double)this.context.value((IAnimatableValue)this.blurriness);
        if (blur == 0.0) {
            return null;
        }
        boolean repeatEdgePixels = (Boolean)this.context.value((IAnimatableValue)this.repeatEdgePixels);
        BlurDimensions dimensions = (BlurDimensions)((Object)this.context.value(this.blurDimensions));
        boolean horz = dimensions != BlurDimensions.VERTICAL;
        boolean vert = dimensions != BlurDimensions.HORIZONTAL;
        boolean fast = blur > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        blur = this.context.getRenderResolution().scale(blur);
        GL2 gl = this.context.getGL().getGL2();
        GLU glu = this.context.getGLU();
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds inputBounds = input.getBounds();
        int sampleRatio = 1;
        if (fast) {
            VideoBounds bounds = inputBounds;
            int[] nArray = BlurUtil.getDownSampleFactors(blur);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int factor = nArray[n2];
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                }
                int hFactor = horz ? factor : 1;
                int vFactor = vert ? factor : 1;
                bounds = new VideoBounds(bounds.x / (double)hFactor, bounds.y / (double)vFactor, (bounds.width + hFactor - 1) / hFactor, (bounds.height + vFactor - 1) / vFactor);
                IVideoBuffer buf = this.context.createVideoBuffer(bounds);
                BlurUtil.doDownSample(input, buf, hFactor, vFactor, gl, glu, this.shaders);
                input.dispose();
                input = buf;
                sampleRatio *= factor;
                ++n2;
            }
            blur /= (double)sampleRatio;
        }
        int radius = (int)Math.ceil(blur);
        double sigma = blur / 2.5;
        double sigmaSquare = sigma * sigma;
        float[] kernel = new float[radius * 2 + 1];
        float sum = 0.0f;
        int i = 1;
        while (i <= radius) {
            float f = (float)Math.exp((double)(-i * i) / (2.0 * sigmaSquare));
            kernel[radius - i] = f;
            sum += 2.0f * f;
            ++i;
        }
        kernel[radius] = 1.0f / (sum += 1.0f);
        i = 1;
        while (i <= radius) {
            int n = radius - i;
            float f = kernel[n] / sum;
            kernel[n] = f;
            kernel[radius + i] = f;
            ++i;
        }
        IVideoBuffer buf1 = null;
        IVideoBuffer buf2 = null;
        IVideoBuffer buf3 = null;
        try {
            VideoBounds bounds;
            if (horz) {
                bounds = input.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, true, false);
                }
                buf1 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(input, buf1, true, radius, kernel, gl, glu, this.shaders);
            } else {
                buf1 = input;
                input = null;
            }
            if (vert) {
                bounds = buf1.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf1, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, false, true);
                }
                buf2 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(buf1, buf2, false, radius, kernel, gl, glu, this.shaders);
            } else {
                buf2 = buf1;
                buf1 = null;
            }
            if (sampleRatio != 1) {
                VideoBounds bounds2;
                int vRatio;
                int hRatio = horz ? sampleRatio : 1;
                int n = vRatio = vert ? sampleRatio : 1;
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf2, gl);
                    bounds2 = inputBounds;
                } else {
                    bounds2 = buf2.getBounds();
                    bounds2 = new VideoBounds(bounds2.x * (double)hRatio, bounds2.y * (double)vRatio, bounds2.width * hRatio, bounds2.height * vRatio);
                }
                buf3 = this.context.createVideoBuffer(bounds2);
                BlurUtil.doUpSample(buf2, buf3, hRatio, vRatio, gl, glu);
            } else {
                buf3 = buf2;
                buf2 = null;
            }
            IVideoBuffer iVideoBuffer = buf3;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buf1 != null) {
                buf1.dispose();
            }
            if (buf2 != null) {
                buf2.dispose();
            }
        }
    }
}

