/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.player;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

import ch.kuramo.javie.app.ImageUtil;

public class PlayerMuteAction extends Action {

	private final MediaPlayer mediaPlayer;


	public PlayerMuteAction(MediaPlayer mediaPlayer) {
		super("消音", IAction.AS_CHECK_BOX);
		this.mediaPlayer = mediaPlayer;

		if (mediaPlayer.hasAudio()) {
			boolean muted = mediaPlayer.isAudioMuted();
			setChecked(!muted);
			setImageDescriptor(ImageUtil.getPlayerMuteIcon(muted));
		} else {
			setEnabled(false);
			setImageDescriptor(ImageUtil.getPlayerMuteIcon(true));
		}
	}

	@Override
	public void run() {
		boolean muted = !isChecked();
		mediaPlayer.setAudioMuted(muted);
		setImageDescriptor(ImageUtil.getPlayerMuteIcon(muted));
	}

}
